/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.lang.acl.ACLMessage;
import jade.tools.gui.ACLPerformativesRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.UIManager;

public class ACLComboBox
extends JComboBox
implements Observer {
    private static String[] fipaProtocols = new String[]{"", "fipa-request", "fipa-query", "fipa-request-when", "fipa-auction-english", "fipa-auction-dutch", "fipa-brokering", "fipa-recruiting", "fipa-propose", "fipa-contract-net", "fipa-iterated-contract-net"};
    private DefaultComboBoxModel comboBoxModel = new DefaultComboBoxModel();
    private ACLMessage msg;
    private String fieldName;

    public void setEditable(boolean theBool) {
        super.setEditable(theBool);
        this.setEnabled(theBool);
    }

    public void registerPerformatives(Object arg) {
        this.comboBoxModel.removeAllElements();
        String[] names = ACLMessage.getAllPerformativeNames();
        for (int i = 0; i < names.length; ++i) {
            this.comboBoxModel.addElement(names[i]);
        }
        this.setModel(this.comboBoxModel);
        this.setRenderer(new ACLPerformativesRenderer());
        this.msg = (ACLMessage)arg;
        this.setSelectedIndex(this.msg.getPerformative());
        String methodName = "get" + this.fieldName;
        String theType = "java.lang.String";
        this.setBackground(Color.white);
        this.setFont(new Font("Dialog", 1, 11));
        Color foreGround = ACLPerformativesRenderer.determineColor(ACLMessage.getPerformative(this.msg.getPerformative()));
        this.setForeground(foreGround);
        UIManager.put("ComboBox.disabledForeground", foreGround);
        UIManager.put("ComboBox.disabledBackground", Color.white);
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ACLComboBox.this.performativeItemStateChanged();
            }
        });
        this.repaint();
        this.updateUI();
    }

    public void registerProtocol(Object arg) {
        this.comboBoxModel.removeAllElements();
        for (int i = 0; i < fipaProtocols.length; ++i) {
            this.comboBoxModel.addElement(fipaProtocols[i]);
        }
        this.setModel(this.comboBoxModel);
        this.msg = (ACLMessage)arg;
        this.setSelectedItem(this.msg.getProtocol());
        String methodName = "get" + this.fieldName;
        String theType = "java.lang.String";
        this.setBackground(Color.white);
        UIManager.put("ComboBox.disabledForeground", Color.black);
        UIManager.put("ComboBox.disabledBackground", Color.white);
        this.setFont(new Font("Dialog", 0, 11));
        this.setEditable(true);
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ACLComboBox.this.protocolItemStateChanged();
            }
        });
        this.repaint();
        this.updateUI();
    }

    public void update(Observable ob, Object arg) {
    }

    public void focusLost(FocusEvent e) {
    }

    void performativeItemStateChanged() {
        if (this.getSelectedItem() == null) {
            return;
        }
        String value = (String)this.getSelectedItem();
        this.setForeground(ACLPerformativesRenderer.determineColor(value));
        if (this.isEnabled()) {
            int i = this.getSelectedIndex();
            this.msg.setPerformative(i);
        }
    }

    void protocolItemStateChanged() {
        if (this.getSelectedItem() == null) {
            return;
        }
        if (this.isEnabled()) {
            String value = (String)this.getSelectedItem();
            this.msg.setProtocol(value);
        }
    }
}

