/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.sniffer;

import jade.core.AID;
import jade.tools.sniffer.ActionProcessor;
import jade.tools.sniffer.Agent;
import jade.tools.sniffer.MainMenu;
import jade.tools.sniffer.MainPanel;
import jade.tools.sniffer.PopupMenuAgent;
import jade.tools.sniffer.Sniffer;
import jade.tools.sniffer.ToolBar;
import jade.util.ExtendedProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MainWindow
extends JFrame {
    protected MainPanel mainPanel;
    protected ActionProcessor actPro;
    private PopupMenuAgent popA;
    private Sniffer mySniffer;
    private ExtendedProperties myProperties;
    private String snifferLogo = "images/sniffer.gif";

    public MainWindow(Sniffer mySniffer, ExtendedProperties myProperties) {
        super(mySniffer.getName() + " - Sniffer Agent");
        this.mySniffer = mySniffer;
        this.myProperties = myProperties;
        this.mainPanel = new MainPanel(mySniffer, this);
        this.actPro = new ActionProcessor(mySniffer, this.mainPanel);
        this.setJMenuBar(new MainMenu(this, this.actPro));
        this.popA = new PopupMenuAgent(this.actPro);
        this.setForeground(Color.black);
        this.setBackground(Color.lightGray);
        Image image = this.getToolkit().getImage(this.getClass().getResource(this.snifferLogo));
        this.setIconImage(image);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainWindow.this.mySniffer.doDelete();
            }
        });
        this.mainPanel.treeAgent.setNewPopupMenu("FIPAAGENT", this.popA);
        this.getContentPane().add((Component)new ToolBar(this.actPro), "North");
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    public void ShowCorrect() {
        this.pack();
        this.setSize(new Dimension(700, 500));
        this.mainPanel.adjustDividerLocation();
        this.setVisible(true);
        this.toFront();
    }

    public ExtendedProperties getProperties() {
        return this.myProperties;
    }

    public void resetTree() {
        Runnable resetIt = new Runnable(){

            public void run() {
                MainWindow.this.mainPanel.treeAgent.clearLocalPlatform();
            }
        };
        SwingUtilities.invokeLater(resetIt);
    }

    public void addContainer(final String name, final InetAddress addr) {
        Runnable addIt = new Runnable(){

            public void run() {
                MainWindow.this.mainPanel.treeAgent.addContainerNode(name, addr);
            }
        };
        SwingUtilities.invokeLater(addIt);
    }

    public void removeContainer(final String name) {
        Runnable removeIt = new Runnable(){

            public void run() {
                MainWindow.this.mainPanel.treeAgent.removeContainerNode(name);
            }
        };
        SwingUtilities.invokeLater(removeIt);
    }

    public void addAgent(final String containerName, final AID agentID) {
        Runnable addIt = new Runnable(){

            public void run() {
                String agentName = agentID.getName();
                MainWindow.this.mainPanel.treeAgent.addAgentNode(agentName, "agentAddress", containerName);
            }
        };
        SwingUtilities.invokeLater(addIt);
    }

    public void removeAgent(final String containerName, final AID agentID) {
        Runnable removeIt = new Runnable(){

            public void run() {
                String agentName = agentID.getName();
                MainWindow.this.mainPanel.treeAgent.removeAgentNode(containerName, agentName);
                MainWindow.this.mainPanel.panelcan.canvAgent.removeAgent(agentName);
                MainWindow.this.mainPanel.panelcan.canvAgent.repaintNoSniffedAgent(new Agent(agentID));
            }
        };
        SwingUtilities.invokeLater(removeIt);
    }

    public void showError(String errMsg) {
        JOptionPane.showMessageDialog(null, errMsg, "Error in " + this.mySniffer.getName(), 0);
    }

    public Dimension getPreferredSize() {
        return new Dimension(700, 500);
    }

    private void setUI(String ui) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf." + ui);
            SwingUtilities.updateComponentTreeUI(this);
            this.pack();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace(System.out);
        }
    }

    public void setUI2Motif() {
        this.setUI("motif.MotifLookAndFeel");
    }

    public void setUI2Windows() {
        this.setUI("windows.WindowsLookAndFeel");
    }

    public void setUI2Multi() {
        this.setUI("multi.MultiLookAndFeel");
    }

    public void setUI2Metal() {
        this.setUI("metal.MetalLookAndFeel");
    }

    public void disposeAsync() {
        class DisposeIt
        implements Runnable {
            private Window toDispose;

            public DisposeIt(Window w) {
                this.toDispose = w;
            }

            public void run() {
                this.toDispose.dispose();
            }
        }
        SwingUtilities.invokeLater(new DisposeIt(this));
    }
}

