/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.Location;
import jade.core.NotFoundException;
import jade.wrapper.AgentController;
import jade.wrapper.AgentState;
import jade.wrapper.ContainerProxy;
import jade.wrapper.O2AException;
import jade.wrapper.O2AProxy;
import jade.wrapper.StaleProxyException;
import jade.wrapper.State;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AgentControllerImpl
implements AgentController {
    private AID agentID;
    private ContainerProxy myProxy;
    private AgentContainer myContainer;

    public AgentControllerImpl(AID id, ContainerProxy cp, AgentContainer ac) {
        this.agentID = id;
        this.myProxy = cp;
        this.myContainer = ac;
    }

    @Override
    public String getName() throws StaleProxyException {
        Agent a = this.myContainer.acquireLocalAgent(this.agentID);
        if (a == null) {
            throw new StaleProxyException("Controlled agent not found");
        }
        this.myContainer.releaseLocalAgent(this.agentID);
        return this.agentID.getName();
    }

    @Override
    public void start() throws StaleProxyException {
        try {
            this.myContainer.powerUpLocalAgent(this.agentID);
        }
        catch (NotFoundException nfe) {
            throw new StaleProxyException("Controlled agent not found");
        }
    }

    @Override
    public void suspend() throws StaleProxyException {
        try {
            this.myProxy.suspendAgent(this.agentID);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    @Override
    public void activate() throws StaleProxyException {
        try {
            this.myProxy.activateAgent(this.agentID);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    @Override
    public void kill() throws StaleProxyException {
        try {
            this.myProxy.killAgent(this.agentID);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    @Override
    public void move(Location where) throws StaleProxyException {
        try {
            this.myProxy.moveAgent(this.agentID, where);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    @Override
    public void clone(Location where, String newName) throws StaleProxyException {
        try {
            this.myProxy.cloneAgent(this.agentID, where, newName);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    @Override
    public void putO2AObject(Object o, boolean blocking) throws StaleProxyException {
        Agent adaptee = this.myContainer.acquireLocalAgent(this.agentID);
        if (adaptee == null) {
            throw new StaleProxyException("Controlled agent does not exist");
        }
        try {
            try {
                adaptee.putO2AObject(o, blocking);
            }
            catch (InterruptedException ace) {
                throw new StaleProxyException(ace);
            }
            Object var6_4 = null;
            this.myContainer.releaseLocalAgent(this.agentID);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.myContainer.releaseLocalAgent(this.agentID);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getO2AInterface(Class<T> theInterface) throws StaleProxyException {
        T o2aInterfaceImpl;
        block4: {
            T t;
            Agent adaptee = this.myContainer.acquireLocalAgent(this.agentID);
            if (adaptee == null) {
                throw new StaleProxyException("Controlled agent does not exist");
            }
            try {
                o2aInterfaceImpl = adaptee.getO2AInterface(theInterface);
                if (o2aInterfaceImpl != null) break block4;
                t = null;
                Object var7_6 = null;
                this.myContainer.releaseLocalAgent(this.agentID);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.myContainer.releaseLocalAgent(this.agentID);
                throw throwable;
            }
            return t;
        }
        ClassLoader classLoader = o2aInterfaceImpl.getClass().getClassLoader();
        Object object = Proxy.newProxyInstance(classLoader, new Class[]{theInterface}, (InvocationHandler)new O2AProxy(o2aInterfaceImpl){

            protected void checkAgent() throws O2AException {
                if (!AgentControllerImpl.this.myContainer.isLocalAgent(AgentControllerImpl.this.agentID)) {
                    throw new O2AException("Controlled agent does not exist");
                }
            }
        });
        Object var7_7 = null;
        this.myContainer.releaseLocalAgent(this.agentID);
        return (T)object;
    }

    @Override
    public State getState() throws StaleProxyException {
        Agent adaptee = this.myContainer.acquireLocalAgent(this.agentID);
        if (adaptee == null) {
            throw new StaleProxyException("Controlled agent does not exist");
        }
        int jadeState = adaptee.getState();
        State ret = null;
        switch (jadeState) {
            case 1: {
                ret = AgentState.AGENT_STATE_INITIATED;
                break;
            }
            case 2: {
                ret = AgentState.AGENT_STATE_ACTIVE;
                break;
            }
            case 3: {
                ret = AgentState.AGENT_STATE_IDLE;
                break;
            }
            case 4: {
                ret = AgentState.AGENT_STATE_SUSPENDED;
                break;
            }
            case 5: {
                ret = AgentState.AGENT_STATE_WAITING;
                break;
            }
            case 6: {
                ret = AgentState.AGENT_STATE_DELETED;
                break;
            }
            default: {
                throw new InternalError("Unknown state: " + jadeState);
            }
        }
        this.myContainer.releaseLocalAgent(this.agentID);
        return ret;
    }
}

