/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.examples.capabilities;

import bdi4jade.annotation.Belief;
import bdi4jade.event.GoalEvent;
import bdi4jade.examples.capabilities.BottomCapability;
import bdi4jade.examples.capabilities.Middle1Capability;
import bdi4jade.examples.capabilities.Middle1ParentCapability;
import bdi4jade.examples.capabilities.Middle2Capability;
import bdi4jade.examples.capabilities.TopCapability;
import bdi4jade.examples.capabilities.TopParentCapability;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalStatus;
import bdi4jade.plan.Plan;
import bdi4jade.plan.planbody.AbstractPlanBody;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestPlanBody
extends AbstractPlanBody {
    private static final Log log = LogFactory.getLog(TestPlanBody.class);
    private static final long serialVersionUID = -9039447524062487795L;
    @Belief
    private bdi4jade.belief.Belief<String, String> bottomBelief;
    @Belief
    private bdi4jade.belief.Belief<String, String> middle1Belief;
    @Belief
    private bdi4jade.belief.Belief<String, String> middle1ParentBelief;
    @Belief
    private bdi4jade.belief.Belief<String, String> middle2Belief;
    private TestStep step;
    @Belief
    private bdi4jade.belief.Belief<String, String> topBelief;
    @Belief
    private bdi4jade.belief.Belief<String, String> topParentBelief;

    public void action() {
        switch (this.step) {
            case BELIEF: {
                log.info((Object)"Testing beliefs...");
                log.info((Object)"These should be not null:");
                log.info((Object)("topParentBelief: " + this.topParentBelief));
                log.info((Object)("topBelief: " + this.topBelief));
                log.info((Object)("middle1ParentBelief: " + this.middle1ParentBelief));
                log.info((Object)("middle1Belief: " + this.middle1Belief));
                log.info((Object)"These should be null:");
                log.info((Object)("middle2Belief: " + this.middle2Belief));
                log.info((Object)("bottomBelief: " + this.bottomBelief));
                log.info((Object)"Testing plans...");
                this.dispatchSubgoalAndListen(new Middle1Capability.Middle1ExternalGoal());
                this.step = TestStep.MY_EXTERNAL_GOAL;
                break;
            }
            case MY_EXTERNAL_GOAL: {
                GoalEvent goalEvent = this.getGoalEvent();
                if (goalEvent == null) {
                    return;
                }
                this.printGoal(goalEvent, true);
                this.dispatchSubgoalAndListen(new Middle1Capability.Middle1InternalGoal());
                this.step = TestStep.MY_INTERNAL_GOAL;
                break;
            }
            case MY_INTERNAL_GOAL: {
                GoalEvent goalEvent = this.getGoalEvent();
                if (goalEvent == null) {
                    return;
                }
                this.printGoal(goalEvent, true);
                this.dispatchSubgoalAndListen(new Middle1ParentCapability.Middle1ParentInternalGoal());
                this.step = TestStep.MY_PARENT_INTERNAL_GOAL;
                break;
            }
            case MY_PARENT_INTERNAL_GOAL: {
                GoalEvent goalEvent = this.getGoalEvent();
                if (goalEvent == null) {
                    return;
                }
                this.printGoal(goalEvent, true);
                this.dispatchSubgoalAndListen(new TopCapability.TopExternalGoal());
                this.step = TestStep.TOP_EXTERNAL_GOAL;
                break;
            }
            case TOP_EXTERNAL_GOAL: {
                GoalEvent goalEvent = this.getGoalEvent();
                if (goalEvent == null) {
                    return;
                }
                this.printGoal(goalEvent, true);
                this.dispatchSubgoalAndListen(new TopCapability.TopInternalGoal());
                this.step = TestStep.TOP_INTERNAL_GOAL;
                break;
            }
            case TOP_INTERNAL_GOAL: {
                GoalEvent goalEvent = this.getGoalEvent();
                if (goalEvent == null) {
                    return;
                }
                this.printGoal(goalEvent, true);
                this.dispatchSubgoalAndListen(new TopParentCapability.TopParentInternalGoal());
                this.step = TestStep.TOP_PARENT_INTERNAL_GOAL;
                break;
            }
            case TOP_PARENT_INTERNAL_GOAL: {
                GoalEvent goalEvent = this.getGoalEvent();
                if (goalEvent == null) {
                    return;
                }
                this.printGoal(goalEvent, true);
                Middle2Capability.Middle2ExternalGoal goal = new Middle2Capability.Middle2ExternalGoal();
                this.printGoal(goal, this.dispatchSubgoal(goal), false);
                this.step = TestStep.MIDDLE2_EXTERNAL_GOAL;
                break;
            }
            case MIDDLE2_EXTERNAL_GOAL: {
                this.dispatchSubgoalAndListen(new BottomCapability.BottomExternalGoal());
                this.step = TestStep.BOTTOM_EXTERNAL_GOAL;
                break;
            }
            case BOTTOM_EXTERNAL_GOAL: {
                GoalEvent goalEvent = this.getGoalEvent();
                if (goalEvent == null) {
                    return;
                }
                this.printGoal(goalEvent, true);
                BottomCapability.BottomInternalGoal goal = new BottomCapability.BottomInternalGoal();
                this.printGoal(goal, this.dispatchSubgoal(goal), false);
                this.step = TestStep.BOTTOM_INTERNAL_GOAL;
                break;
            }
            case BOTTOM_INTERNAL_GOAL: {
                this.step = TestStep.COMPLETED;
                break;
            }
            case COMPLETED: {
                this.setEndState(Plan.EndState.SUCCESSFUL);
            }
        }
    }

    public void onStart() {
        this.step = TestStep.BELIEF;
    }

    private void printGoal(Goal goal, boolean observed, boolean expected) {
        log.debug((Object)("Goal " + goal.getClass().getSimpleName() + " dispatched - " + (observed == expected ? "" : "un") + "expected result"));
    }

    private void printGoal(GoalEvent goalEvent, boolean achievedExpected) {
        if (GoalStatus.ACHIEVED.equals((Object)goalEvent.getStatus())) {
            log.debug((Object)("Goal " + goalEvent.getGoal().getClass().getSimpleName() + " completed - " + (achievedExpected ? "" : "un") + "expected result"));
        } else {
            log.debug((Object)("A goal has failed: " + goalEvent.getGoal().getClass().getSimpleName() + " - " + (achievedExpected ? "un" : "") + "expected result"));
        }
    }

    static enum TestStep {
        BELIEF,
        BOTTOM_EXTERNAL_GOAL,
        BOTTOM_INTERNAL_GOAL,
        COMPLETED,
        MIDDLE2_EXTERNAL_GOAL,
        MY_EXTERNAL_GOAL,
        MY_INTERNAL_GOAL,
        MY_PARENT_INTERNAL_GOAL,
        TOP_EXTERNAL_GOAL,
        TOP_INTERNAL_GOAL,
        TOP_PARENT_INTERNAL_GOAL;

    }
}

