/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.goal;

import bdi4jade.annotation.Parameter;
import bdi4jade.belief.Belief;
import bdi4jade.belief.BeliefBase;
import bdi4jade.goal.AbstractBeliefGoal;

public class BeliefValueGoal<K, V>
extends AbstractBeliefGoal<K> {
    private static final long serialVersionUID = 2493877854717226283L;
    private V value;

    public BeliefValueGoal() {
    }

    public BeliefValueGoal(K beliefName) {
        this(beliefName, null);
    }

    public BeliefValueGoal(K beliefName, V value) {
        super(beliefName);
        this.value = value;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BeliefValueGoal) {
            BeliefValueGoal bg = (BeliefValueGoal)obj;
            if (!this.beliefName.equals(bg.beliefName)) {
                return false;
            }
            if (this.value == null) {
                return bg.value == null;
            }
            if (bg.value == null) {
                return false;
            }
            return this.value.equals(bg.value);
        }
        return false;
    }

    @Parameter(direction=Parameter.Direction.IN)
    public V getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = BeliefValueGoal.class.hashCode();
        result = 31 * result + (this.beliefName == null ? 0 : this.beliefName.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean isAchieved(BeliefBase beliefBase) {
        Belief<?, ?> belief = beliefBase.getBelief(this.beliefName);
        if (belief == null) {
            return false;
        }
        if (this.value == null) {
            return belief.getValue() == null;
        }
        if (belief.getValue() == null) {
            return false;
        }
        return belief.getValue().equals(this.value);
    }

    public void setValue(V value) {
        this.value = value;
    }

    public String toString() {
        return new StringBuffer(this.getClass().getName()).append(": ").append(this.getBeliefName()).append("=").append(this.value).toString();
    }
}

