package bdi4jade.extension.remediation.goal;

import bdi4jade.extension.remediation.logics.Fact;
import bdi4jade.goal.BeliefPresentGoal;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalStatus;
import bdi4jade.goal.PredicateGoal;

public class CauseFactorStatus {

	private Goal achievementGoal;
	private GoalStatus achievementGoalStatus;
	private final Fact fact;
	private Boolean initialStatus;
	private Goal testGoal;
	private GoalStatus testGoalStatus;
	private Boolean updatedStatus;

	public CauseFactorStatus(Fact fact) {
		this.fact = fact;
		this.initialStatus = null;
		this.updatedStatus = null;
		this.testGoal = null;
		this.achievementGoal = null;
		this.testGoalStatus = null;
		this.achievementGoalStatus = null;
	}

	public PredicateGoal<?> generateAchievementGoal() {
		System.out.println("generateAchievementGoal: " + this.fact.getPredicate() + "<" + !this.fact.getValue() + ">");
		this.achievementGoal = new PredicateGoal(this.fact.getPredicate(), !this.fact.getValue());
		return (PredicateGoal<?>) this.achievementGoal;
	}

	public BeliefPresentGoal<?> generateTestGoal() {
		this.testGoal = new BeliefPresentGoal<Object>(this.fact.getPredicate());
		return (BeliefPresentGoal<?>) this.testGoal;
	}

	public Goal getAchievementGoal() {
		return achievementGoal;
	}

	public GoalStatus getAchievementGoalStatus() {
		return achievementGoalStatus;
	}

	public Fact getFact() {
		return fact;
	}

	public Boolean getInitialStatus() {
		return initialStatus;
	}

	public Goal getTestGoal() {
		return testGoal;
	}

	public GoalStatus getTestGoalStatus() {
		return testGoalStatus;
	}

	public Boolean getUpdatedStatus() {
		return updatedStatus;
	}

	public void setAchievementGoal(Goal achievementGoal) {
		this.achievementGoal = achievementGoal;
	}

	public void setAchievementGoalStatus(GoalStatus achievementGoalStatus) {
		this.achievementGoalStatus = achievementGoalStatus;
	}

	public void setInitialStatus(Boolean initialStatus) {
		this.initialStatus = initialStatus;
	}

	public void setTestGoal(Goal testGoal) {
		this.testGoal = testGoal;
	}

	public void setTestGoalStatus(GoalStatus testGoalStatus) {
		this.testGoalStatus = testGoalStatus;
	}

	public void setUpdatedStatus(Boolean updatedStatus) {
		this.updatedStatus = updatedStatus;
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("< ").append(fact);
		sb.append(", s_i = ").append(initialStatus);
		sb.append(", s_u = ").append(updatedStatus);
		sb.append(", ?g = ").append(testGoal);
		sb.append(" [").append(testGoalStatus).append("]");
		sb.append(", !g = ").append(achievementGoal);
		sb.append(" [").append(achievementGoalStatus).append("] >");
		return sb.toString();
	}

}
