//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.extension.remediation.logics;

import java.util.HashMap;
import java.util.Map;

import bdi4jade.belief.Belief;
import bdi4jade.belief.BeliefBase;
import bdi4jade.extension.remediation.logics.MathExpression.Operator;

/**
 * @author ingridnunes
 *
 */
public class MathExpression<T> extends TernaryPredicate<T, Operator, Double> {

	private static final long serialVersionUID = 11514826399908986L;

	public enum Operator {

		EQUAL_TO, NOT_EQUAL_TO, LESS_THAN, LESS_THAN_OR_EQUAL_TO, GREATER_THAN, GREATER_THAN_OR_EQUAL_TO;

	}
	
	public MathExpression() {
		
	}
	
	public MathExpression(T freeVariable, Operator operator, Double value) {
		super(freeVariable, operator, value);
	}
	
	@Override
	public Boolean getValue(BeliefBase beliefBase) {
		Belief<T, Double> belief = (Belief<T, Double>) beliefBase.getBelief(getVariable1());
		Map<Object, Object> values = new HashMap<>();
		values.put(getVariable1(), belief.getValue());
		return getValue(beliefBase);
	}
	
	@Override
	public Boolean getValue(Map<Object, Object> values) {
		Double variableValue = (Double) values.get(getVariable1());
		switch (getVariable2()) {
		case EQUAL_TO:
			return variableValue == getVariable3();
		case NOT_EQUAL_TO:
			return variableValue != getVariable3();
		case LESS_THAN:
			return variableValue < getVariable3();
		case LESS_THAN_OR_EQUAL_TO:
			return variableValue <= getVariable3();
		case GREATER_THAN:
			return variableValue > getVariable3();
		case GREATER_THAN_OR_EQUAL_TO:
			return variableValue >= getVariable3();
		}
		return null;
	}

}
