//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol;

import java.util.HashMap;
import java.util.Map;

import bdi4jade.annotation.Belief;
import bdi4jade.core.Capability;
import bdi4jade.examples.interactionprotocol.domain.Component;
import bdi4jade.examples.interactionprotocol.domain.Service;
import bdi4jade.examples.interactionprotocol.domain.predicate.AnomalousComponent;
import bdi4jade.examples.interactionprotocol.goal.MonitorMetricsGoal;
import bdi4jade.examples.interactionprotocol.plan.MonitorMetricsPlanBody;
import bdi4jade.examples.interactionprotocol.plan.NotifyAnomalousComponentPlanBody;
import bdi4jade.goal.GoalTemplateFactory;
import bdi4jade.plan.DefaultPlan;
import bdi4jade.plan.Plan;

/**
 * @author jgfaccin
 *
 */
public class MonitorMetricsCapability extends Capability {

	private static final long serialVersionUID = -5800167858824897939L;
	public static final String SERVICE = "A";
	public static final String PROVIDER = "AGENT01";

	@Belief
	private Map<Service, Component> currentProviders;

	@bdi4jade.annotation.Plan
	private Plan monitorMetricsPlan;
	@bdi4jade.annotation.Plan
	private Plan notifyAnomalyPlan;

	public MonitorMetricsCapability() {
		super();
		this.currentProviders = new HashMap<Service, Component>();
		this.currentProviders.put(new Service(SERVICE), new Component(PROVIDER));
		this.monitorMetricsPlan = new DefaultPlan(MonitorMetricsGoal.class, MonitorMetricsPlanBody.class);
		this.notifyAnomalyPlan = new DefaultPlan(
				GoalTemplateFactory.hasBeliefOfTypeWithValue(AnomalousComponent.class, false),
				NotifyAnomalousComponentPlanBody.class);
	}
}
