//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.domain;

import java.io.Serializable;

import jade.content.Concept;
import jade.content.ContentElement;

/**
 * @author jgfaccin
 *
 */
public class Communication implements Serializable, Concept, ContentElement {

	private static final long serialVersionUID = -3011235813999398006L;

	private Component component;
	private Service service;
	
	
	public Communication(Component component, Service service) {
		this.component = component;
		this.service = service;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Communication) {
			Communication communication = (Communication) obj;
			return this.component.equals(communication.component) && this.service.equals(communication.service);
		}
		return false;
	}

	public Component getComponent() {
		return component;
	}
	
	public Service getService() {
		return service;
	}

	@Override
	public int hashCode() {
		if (component != null && service != null) {
			return component.hashCode() + service.hashCode();
		}
		return 0;
	}

	public void setComponent(Component component) {
		this.component = component;
	}
	
	public void setService(Service service) {
		this.service = service;
	}

	@Override
	public String toString() {
		return "Communication<" + service + ", " + component + ">";
	}
}
