//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.domain;

import java.io.Serializable;

import jade.content.Concept;
import jade.content.ContentElement;

/**
 * @author jgfaccin
 *
 */
public class Component implements Serializable, Concept, ContentElement {
	
	private static final long serialVersionUID = 2336016887215657247L;
	
	public static final String NAME = "COMPONENT";
	
	private String id;
	
	public Component(String id) {
		this.id = id;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Component) {
			Component component = (Component) obj;
			return this.id.equals(component.id);
		}
		return false;
	}

	public String getId() {
		return id;
	}

	@Override
	public int hashCode() {
		return id == null ? 0 : id.hashCode();
	}

	public void setId(String id) {
		this.id = id;
	}

	@Override
	public String toString() {
		return id;
	}
	
}
