//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.domain;

import java.util.ArrayList;

public class LinkMonitor {

	private ArrayList<Link> anomalousLinks;
	private static LinkMonitor instance;

	private LinkMonitor() {
		this.anomalousLinks = new ArrayList<Link>();
	}

	public static synchronized LinkMonitor getInstance() {
		if (instance == null) {
			instance = new LinkMonitor();
		}
		return instance;
	}

	public ArrayList<Link> getAnomalousLinks() {
		return this.anomalousLinks;
	}

}
