//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.dummy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import bdi4jade.annotation.Belief;
import bdi4jade.core.Capability;
import bdi4jade.examples.interactionprotocol.domain.Component;
import bdi4jade.examples.interactionprotocol.domain.Service;
import bdi4jade.examples.interactionprotocol.goal.ProvideServiceGoal;
import bdi4jade.examples.interactionprotocol.goal.RequestServiceGoal;
import bdi4jade.examples.interactionprotocol.goal.VerifyAbnormalBehaviourGoal;
import bdi4jade.examples.interactionprotocol.plan.DoNothingPlanBody;
import bdi4jade.examples.interactionprotocol.plan.ProvideServicePlanBody;
import bdi4jade.examples.interactionprotocol.plan.RequestServicePlanBody;
import bdi4jade.goal.GoalTemplateFactory;
import bdi4jade.plan.DefaultPlan;
import bdi4jade.plan.Plan;
import bdi4jade.reasoning.DefaultBeliefRevisionStrategy;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

/**
 * @author jgfaccin
 *
 */
public class DummyCapability extends Capability {

	private static final long serialVersionUID = 7925397404457745783L;

	// Beliefs
	@Belief
	private Map<Service, ArrayList<Service>> myServices;
	@Belief
	private Map<Service, Integer> serviceCost;
	@Belief
	private Map<Service, Component> currentProviders;
	@Belief
	private ArrayList<Component> unavailableProviders;
	@Belief
	private Boolean failure;
	
	@bdi4jade.annotation.Plan
	private Plan provideServicePlan;
	@bdi4jade.annotation.Plan
	private Plan requestServicePlan;
	@bdi4jade.annotation.Plan
	private Plan doNothingPlan;
	
	public DummyCapability(Map<Service, ArrayList<Service>> myServices) {
		this.myServices = myServices;
		this.serviceCost = new HashMap<Service, Integer>();
		this.unavailableProviders = new ArrayList<>();
		this.failure = false;
		this.currentProviders = new HashMap<Service, Component>();
		
		this.provideServicePlan = new DefaultPlan(ProvideServiceGoal.class, ProvideServicePlanBody.class);
		this.requestServicePlan = new DefaultPlan(GoalTemplateFactory.goalOfType(RequestServiceGoal.class),
				RequestServicePlanBody.class);
		this.doNothingPlan = new DefaultPlan(VerifyAbnormalBehaviourGoal.class, DoNothingPlanBody.class);
		
		setBeliefRevisionStrategy(new DummyBeliefRevisionStrategy());
	}
	
	public ArrayList<Service> getMyServices() {
		ArrayList<Service> services = new ArrayList<Service>(this.myServices.keySet());
		return services;
	}

	public ArrayList<Service> getMyServiceDependences(Service service) {
		if (this.myServices.containsKey(service)) {
			return this.myServices.get(service);
		}
		return new ArrayList<Service>();
	}

	public void setCurrentProviders(Map<Service, Component> currentProviders) {
		this.currentProviders = currentProviders;
	}

	public void setServiceCost(Service service, Integer cost) {
		this.serviceCost.put(service, cost);
	}

	public Map<Service, Integer> getServiceCost() {
		return this.serviceCost;
	}
	
	class DummyBeliefRevisionStrategy extends DefaultBeliefRevisionStrategy {
		
		private MessageTemplate mtNotification;
		private MessageTemplate mtServiceRequest;
		
		@Override
		public void reviewBeliefs() {
			super.reviewBeliefs();
			
			this.mtNotification = MessageTemplate.MatchPerformative(ACLMessage.INFORM_REF);
			ACLMessage notificationMsg = getMyAgent().receive(mtNotification);
			if (notificationMsg != null) {
				getMyAgent().addGoal(new VerifyAbnormalBehaviourGoal(notificationMsg));
			}
			
			this.mtServiceRequest = MessageTemplate.MatchPerformative(ACLMessage.REQUEST);
			ACLMessage serviceRequestMsg = getMyAgent().receive(mtServiceRequest);
			if (serviceRequestMsg != null) {
				Service service = new Service(serviceRequestMsg.getContent());
				if (myServices.containsKey(service)) {
					getMyAgent().addGoal(new ProvideServiceGoal(serviceRequestMsg));
				}
			}
		}
	}
}
