//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.experiment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.log4j.PropertyConfigurator;

import bdi4jade.belief.Belief;
import bdi4jade.core.SingleCapabilityAgent;
import bdi4jade.event.GoalEvent;
import bdi4jade.event.GoalListener;
import bdi4jade.examples.interactionprotocol.MonitorMetricsCapability;
import bdi4jade.examples.interactionprotocol.dao.TraceDAO;
import bdi4jade.examples.interactionprotocol.domain.Component;
import bdi4jade.examples.interactionprotocol.domain.Service;
import bdi4jade.examples.interactionprotocol.goal.MonitorMetricsGoal;
import bdi4jade.examples.interactionprotocol.remedial.RemedialCapability;
import bdi4jade.examples.interactionprotocol.remedial.RemedialServiceProvider;
import jade.BootProfileImpl;
import jade.core.ProfileImpl;
import jade.wrapper.AgentContainer;
import jade.wrapper.AgentController;
import jade.wrapper.PlatformController;

/**
 * @author jgfaccin
 *
 */
public class RemedialRunnerOld implements GoalListener {

	public static final int ITERATIONS = 100;

	private ProfileImpl bootProfile;
	private jade.core.Runtime runtime;
	private PlatformController controller;

	private ArrayList<RemedialServiceProvider> providers;
	private SingleCapabilityAgent client;

	private int failurePoint;
	private int iteration;

	public RemedialRunnerOld() {
		this.failurePoint = 50;
		this.iteration = 0;
		List<String> params = new ArrayList<String>();
		params.add("-gui");
		params.add("-detect-main:false");

		this.bootProfile = new BootProfileImpl(params.toArray(new String[0]));
		this.runtime = jade.core.Runtime.instance();
		this.controller = runtime.createMainContainer(bootProfile);

		this.providers = initializeProviderAgents();
		initializeClientAgent();

		HashMap<Service, ArrayList<Service>> serviceDependences = initializeServiceDependenceList();

		setAgentCapabilitiesAndServices(this.providers, serviceDependences);

		for (RemedialServiceProvider providers : this.providers) {
			providers.register();
		}

		setInitialCurrentProviders(this.providers);
	}

	public static void main(String[] args) {
		PropertyConfigurator.configure(RemedialRunnerOld.class.getResource("log4j.properties"));
		RemedialRunnerOld runner = new RemedialRunnerOld();
		runner.run();
	}

	public void run() {
		try {
			Thread.sleep(2000);
			client.addGoal(new MonitorMetricsGoal(), this);

			this.iteration++;
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public void goalPerformed(GoalEvent event) {
		if (event.getStatus().isFinished() && event.getGoal() instanceof MonitorMetricsGoal) {
			if (iteration < ITERATIONS) {
				if (iteration == failurePoint) {

					RemedialServiceProvider agent = providers.get(4);
					Belief<String, Boolean> failure = (Belief<String, Boolean>) agent.getCapability().getBeliefBase()
							.getBelief("failure");
					failure.setValue(true);
					System.out.println("Setting failure to " + agent.getLocalName());

					/*
					 * Link link = new Link(new Component("AGENT0"), new Component("AGENT4"), new
					 * Service("SERVICE2"));
					 * LinkMonitor.getInstance().getAnomalousLinks().add(link);
					 * System.out.println("Setting failure to link: " + link);
					 */

				}

				run();
			} else {
				System.out.println("Iterations finished!!");
			}
		}
	}

	private ArrayList<RemedialServiceProvider> initializeProviderAgents() {
		System.out.println("Initializing 31 service providers...");
		ArrayList<RemedialServiceProvider> agents = new ArrayList<>();

		try {
			for (int i = 0; i < 31; i++) {
				RemedialServiceProvider agent = new RemedialServiceProvider("AGENT" + i);
				agents.add(agent);
				AgentController ac = ((AgentContainer) controller).acceptNewAgent(agent.getCustomName(), agent);
				ac.start();
				setupDB(agent);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		System.out.println("Provider agents initialized!");
		return agents;
	}

	private void initializeClientAgent() {
		System.out.println("Initializing client agent...");
		this.client = new SingleCapabilityAgent();
		try {
			AgentController ac = ((AgentContainer) controller).acceptNewAgent("CLIENT", this.client);
			ac.start();
		} catch (Exception e) {
			e.printStackTrace();
		}
		System.out.println("Client agent initalized!");
	}

	private HashMap<Service, ArrayList<Service>> initializeServiceDependenceList() {
		System.out.println("Creating service dependence list for 10 services...");
		HashMap<Service, ArrayList<Service>> dependenceList = new HashMap<>();
		for (int i = 0; i < 3; i++) {
			Service service = new Service("SERVICE" + i);
			ArrayList<Service> serviceDependences = new ArrayList<Service>();
			serviceDependences.add(new Service("SERVICE" + (2 * i + 1)));
			serviceDependences.add(new Service("SERVICE" + (2 * i + 2)));
			dependenceList.put(service, serviceDependences);
		}

		for (int i = 3, j = 1; i < 7; i++, j--) {
			Service service = new Service("SERVICE" + i);
			ArrayList<Service> serviceDependences = new ArrayList<Service>();
			serviceDependences.add(new Service("SERVICE" + (2 * i + j)));
			dependenceList.put(service, serviceDependences);
		}

		return dependenceList;
	}

	private void setAgentCapabilitiesAndServices(ArrayList<RemedialServiceProvider> providers,
			HashMap<Service, ArrayList<Service>> serviceDependences) {

		setClientAgentCapability();
		System.out.println("Setting provider agent capabilities...");

		RemedialServiceProvider a0 = providers.get(0);
		HashMap<Service, ArrayList<Service>> myServices = new HashMap<Service, ArrayList<Service>>();
		Service s0 = new Service("SERVICE0");
		myServices.put(s0, serviceDependences.get(s0));
		RemedialCapability capability = new RemedialCapability(myServices);
		capability.setServiceCost(s0, 0);
		a0.setCapability(capability);

		int agentCounter = 1;

		for (int i = 1; i < 11; i++) {
			for (int j = 0; j < 3; j++) {
				RemedialServiceProvider provider = providers.get(agentCounter);
				Service service = new Service("SERVICE" + i);

				myServices = new HashMap<Service, ArrayList<Service>>();
				ArrayList<Service> dependences = new ArrayList<Service>();
				if (serviceDependences.get(service) != null) {
					dependences = serviceDependences.get(service);
				}
				myServices.put(service, dependences);
				capability = new RemedialCapability(myServices);
				capability.setServiceCost(service, agentCounter);

				provider.setCapability(capability);
				agentCounter++;
			}
		}
		System.out.println("Provider agent capabilities initialized!");
	}

	private void setClientAgentCapability() {
		System.out.println("Setting client agent capability...");
		this.client.setCapability(new MonitorMetricsCapability());
		System.out.println("Client agent capability initialized!");
	}

	private void setInitialCurrentProviders(ArrayList<RemedialServiceProvider> providers) {
		RemedialServiceProvider agent = providers.get(0);
		RemedialCapability capability = (RemedialCapability) agent.getCapability();
		HashMap<Service, Component> currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE1"), new Component("AGENT1"));
		currentProviders.put(new Service("SERVICE2"), new Component("AGENT4"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(1);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE3"), new Component("AGENT7"));
		currentProviders.put(new Service("SERVICE4"), new Component("AGENT10"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(2);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE3"), new Component("AGENT8"));
		currentProviders.put(new Service("SERVICE4"), new Component("AGENT11"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(3);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE3"), new Component("AGENT9"));
		currentProviders.put(new Service("SERVICE4"), new Component("AGENT12"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(4);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE5"), new Component("AGENT13"));
		currentProviders.put(new Service("SERVICE6"), new Component("AGENT16"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(5);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE5"), new Component("AGENT14"));
		currentProviders.put(new Service("SERVICE6"), new Component("AGENT17"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(6);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE5"), new Component("AGENT15"));
		currentProviders.put(new Service("SERVICE6"), new Component("AGENT18"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(7);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE7"), new Component("AGENT19"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(8);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE7"), new Component("AGENT20"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(9);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE7"), new Component("AGENT21"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(10);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE8"), new Component("AGENT22"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(11);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE8"), new Component("AGENT23"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(12);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE8"), new Component("AGENT24"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(13);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE9"), new Component("AGENT25"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(14);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE9"), new Component("AGENT26"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(15);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE9"), new Component("AGENT27"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(16);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE10"), new Component("AGENT28"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(17);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE10"), new Component("AGENT29"));
		capability.setCurrentProviders(currentProviders);

		agent = providers.get(18);
		capability = (RemedialCapability) agent.getCapability();
		currentProviders = new HashMap<Service, Component>();
		currentProviders.put(new Service("SERVICE10"), new Component("AGENT30"));
		capability.setCurrentProviders(currentProviders);
	}

	private void setupDB(RemedialServiceProvider agent) {
		TraceDAO dao = new TraceDAO(agent.getAID().getLocalName());
		dao.dropCollection();
	}

}
