//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.goal;

import bdi4jade.examples.interactionprotocol.domain.Service;
import bdi4jade.goal.Goal;

/**
 * @author jgfaccin
 *
 */
public class RequestServiceGoal implements Goal {

	private static final long serialVersionUID = -8816235981052740771L;

	private Service service;
	private String parentCid;
	private Integer cost;

	public RequestServiceGoal(Service service, String parentCid) {
		this.service = service;
		this.parentCid = parentCid;
		this.cost = 0;
	}

	public Service getService() {
		return this.service;
	}

	public String getParentCid() {
		return this.parentCid;
	}

	public Integer getCost() {
		return this.cost;
	}

	public void setCost(Integer cost) {
		this.cost = cost;
	}
}
