//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.goal;

import bdi4jade.examples.interactionprotocol.domain.Component;
import bdi4jade.examples.interactionprotocol.domain.Conversation;
import bdi4jade.examples.interactionprotocol.domain.Service;
import bdi4jade.goal.Goal;

/**
 * @author jgfaccin
 *
 */
public class VerifySuspiciousComponentGoal implements Goal {

	private static final long serialVersionUID = -7350855136367882896L;

	private Component component;
	private Service service;
	private Conversation conversation;

	public VerifySuspiciousComponentGoal(Component component, Service service, Conversation conversation) {
		this.component = component;
		this.service = service;
		this.conversation = conversation;
	}

	public Component getComponent() {
		return this.component;
	}

	public Service getService() {
		return this.service;
	}

	public Conversation getConversation() {
		return this.conversation;
	}

}
