//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.plan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

import bdi4jade.belief.Belief;
import bdi4jade.examples.interactionprotocol.domain.Component;
import bdi4jade.examples.interactionprotocol.domain.Service;
import bdi4jade.examples.interactionprotocol.goal.ChangeServiceProviderGoal;
import bdi4jade.plan.Plan.EndState;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ServiceDescription;

/**
 * @author jgfaccin
 *
 */
public class ChangeServiceProviderPlanBody extends YellowPagesPlanBody {

	private static final long serialVersionUID = 7732565620673695278L;

	@bdi4jade.annotation.Belief
	private Belief<String, Map<Service, Component>> currentProviders;
	@bdi4jade.annotation.Belief
	private Belief<String, ArrayList<Component>> unavailableProviders;

	@Override
	public void action() {
		ChangeServiceProviderGoal goal = (ChangeServiceProviderGoal) this.getGoal();
		Service service = goal.getService();
		System.out.println("[" + this.getAgent().getLocalName() + "] Changing provider of " + service.getId());

		ArrayList<DFAgentDescription> descriptions = getServiceProviders(service);

		Map<Integer, String> map = new HashMap<>();
		for (DFAgentDescription dfAgentDescription : descriptions) {
			Integer serviceCost = getServiceCostByAgent(dfAgentDescription, service);
			map.put(serviceCost, dfAgentDescription.getName().getLocalName());
		}

		TreeMap<Integer, String> orderedProviders = new TreeMap<Integer, String>(map);
		boolean flag = true;

		while (flag) {
			Integer key = orderedProviders.firstKey();
			Component candidateProvider = new Component(orderedProviders.get(key).toString());
			if (currentProviders.getValue().containsKey(service)) {
				Component currentProvider = currentProviders.getValue().get(service);
				if (currentProvider == null || (!currentProvider.equals(candidateProvider)
						&& !unavailableProviders.getValue().contains(candidateProvider))) {
					currentProviders.getValue().put(service, candidateProvider);
					flag = false;
				} else {
					orderedProviders.remove(orderedProviders.firstKey());
				}
			}
		}
		System.out.println("[" + this.getAgent().getLocalName() + "] " + service.getId() + "'s provider changed.");
		setEndState(EndState.SUCCESSFUL);
	}

	private Integer getServiceCostByAgent(DFAgentDescription ad, Service service) {
		Integer value = Integer.MAX_VALUE;
		Iterator<?> serviceIterator = ad.getAllServices();
		while (serviceIterator.hasNext()) {
			ServiceDescription sd = (ServiceDescription) serviceIterator.next();
			if (sd.getType().equals(service.getId())) {
				Iterator<?> propertyIterator = sd.getAllProperties();
				while (propertyIterator.hasNext()) {
					Property property = (Property) propertyIterator.next();
					if (property.getName().equals(Service.COST)) {
						value = Integer.valueOf((String) property.getValue());
					}
				}
			}
		}
		return value;
	}
}
