//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.plan;

import java.time.Duration;
import java.time.Instant;

import bdi4jade.belief.TransientPredicate;
import bdi4jade.event.GoalEvent;
import bdi4jade.examples.interactionprotocol.MonitorMetricsCapability;
import bdi4jade.examples.interactionprotocol.domain.Component;
import bdi4jade.examples.interactionprotocol.domain.Conversation;
import bdi4jade.examples.interactionprotocol.domain.Service;
import bdi4jade.examples.interactionprotocol.domain.predicate.AnomalousComponent;
import bdi4jade.goal.PredicateGoal;
import bdi4jade.plan.Plan.EndState;
import bdi4jade.plan.planbody.AbstractPlanBody;
import jade.core.AID;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

/**
 * @author jgfaccin
 *
 */
public class MonitorMetricsPlanBody extends AbstractPlanBody {

	private static final long serialVersionUID = 1240182579625681535L;
	private static int anomalyCounter = 0;

	private static final int METRIC_VALUE = 250;
	private boolean sent = false;
	private boolean dispatched = false;
	private Instant sentAt;
	private MessageTemplate mt;
	private String conversationId;

	@Override
	public void action() {
		if (!sent) {
			ACLMessage msg = new ACLMessage(ACLMessage.REQUEST);
			msg.setContent(MonitorMetricsCapability.SERVICE);
			msg.addReceiver(new AID(MonitorMetricsCapability.PROVIDER, false));

			this.conversationId = this.myAgent.getLocalName() + System.currentTimeMillis();
			msg.setConversationId(this.conversationId);
			myAgent.send(msg);
			this.sentAt = Instant.now();

			//System.out.println("[" + myAgent.getLocalName() + "] Requesting " + MonitorMetricsCapability.SERVICE + " from " + MonitorMetricsCapability.PROVIDER);

			this.mt = MessageTemplate.MatchConversationId(msg.getConversationId());
			this.sent = true;
		} else {
			if (!dispatched) {
				ACLMessage reply = myAgent.receive(mt);
				if (reply != null) {
					Instant receivedAt = Instant.now();
					long delta = Duration.between(sentAt, receivedAt).toMillis();
					System.out.println("Message received after " + delta + "ms.");
					if (delta > METRIC_VALUE) {
						MonitorMetricsPlanBody.anomalyCounter++;
					}
					
					if (MonitorMetricsPlanBody.anomalyCounter == 1) {
						//System.out.println("ANOMALIA DETECTADA!");
						AnomalousComponent anomalousCompPredicate = new AnomalousComponent(
								new Component(MonitorMetricsCapability.PROVIDER),
								new Service(MonitorMetricsCapability.SERVICE), new Conversation(conversationId));
						TransientPredicate<AnomalousComponent> anomalousCompBelief = new TransientPredicate<AnomalousComponent>(
								anomalousCompPredicate, true);
						this.getBeliefBase().addBelief(anomalousCompBelief);
						dispatchSubgoalAndListen(new PredicateGoal<AnomalousComponent>(anomalousCompPredicate, false));
						this.dispatched = true;
					} else {
						this.sent = false;
						setEndState(EndState.SUCCESSFUL);
					}
				} else {
					block();
				}
			} else {
				GoalEvent goalEvent = getGoalEvent();
				if (goalEvent != null) {
					this.sent = false;
					MonitorMetricsPlanBody.anomalyCounter = 0;
					this.dispatched = false;
					setEndState(EndState.SUCCESSFUL);
				}
			}
		}
	}
}
