//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.plan;

import java.util.ArrayList;

import bdi4jade.belief.Belief;
import bdi4jade.belief.TransientPredicate;
import bdi4jade.event.GoalEvent;
import bdi4jade.examples.interactionprotocol.domain.Component;
import bdi4jade.examples.interactionprotocol.domain.Service;
import bdi4jade.examples.interactionprotocol.domain.predicate.AnomalousCommunication;
import bdi4jade.examples.interactionprotocol.goal.ChangeServiceProviderGoal;
import bdi4jade.goal.PredicateGoal;
import bdi4jade.plan.Plan.EndState;
import bdi4jade.plan.planbody.AbstractPlanBody;

/**
 * @author jgfaccin
 *
 */
public class NormalizeCommunicationPlanBody extends AbstractPlanBody {

	private static final long serialVersionUID = -7695129957189675038L;
	private boolean sent = false;
	
	@bdi4jade.annotation.Belief
	private Belief<String, ArrayList<Component>> unavailableProviders;

	@SuppressWarnings("unchecked")
	@Override
	public void action() {
		PredicateGoal<AnomalousCommunication> goal = (PredicateGoal<AnomalousCommunication>) this.getGoal();
		if (!sent) {
			Service service = goal.getBeliefName().getVariable().getService();
			Component component = goal.getBeliefName().getVariable().getComponent();
			unavailableProviders.getValue().add(component);
			System.out.println("[" + this.getAgent().getLocalName() + "] Normalizing communication for " + service.getId());
			dispatchSubgoalAndListen(new ChangeServiceProviderGoal(service));
			this.sent = true;
		} else {
			GoalEvent goalEvent = getGoalEvent();
			if (goalEvent != null) {
				TransientPredicate<AnomalousCommunication> anomalousCommBelief = (TransientPredicate<AnomalousCommunication>) this
						.getCapability().getBeliefBase().getBelief(goal.getBeliefName());
				anomalousCommBelief.setValue(false);
				this.sent = false;
				setEndState(EndState.SUCCESSFUL);
			}
		}
	}
}
