//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.plan;

import java.util.ArrayList;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import bdi4jade.belief.Belief;
import bdi4jade.belief.TransientPredicate;
import bdi4jade.examples.interactionprotocol.domain.Component;
import bdi4jade.examples.interactionprotocol.domain.Conversation;
import bdi4jade.examples.interactionprotocol.domain.Service;
import bdi4jade.examples.interactionprotocol.domain.predicate.AnomalousComponent;
import bdi4jade.goal.PredicateGoal;
import bdi4jade.plan.Plan.EndState;
import bdi4jade.plan.planbody.AbstractPlanBody;
import jade.core.AID;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

/**
 * @author jgfaccin
 *
 */
public class NotifyAnomalousComponentPlanBody extends AbstractPlanBody {

	private static final long serialVersionUID = 1923017302339086902L;
	private final Log log = LogFactory.getLog(this.getClass());

	@bdi4jade.annotation.Belief
	private Belief<String, Map<Service, Component>> currentProviders;
	@bdi4jade.annotation.Belief
	private Belief<String, ArrayList<Component>> unavailableProviders;

	private MessageTemplate mt;
	private boolean sent = false;

	@SuppressWarnings("unchecked")
	@Override
	public void action() {
		PredicateGoal<AnomalousComponent> anomalousCompGoal = (PredicateGoal<AnomalousComponent>) this.getGoal();
		AnomalousComponent anomalousCompPredicate = anomalousCompGoal.getBeliefName();
		if (!sent) {
			Component anomalousComponent = anomalousCompPredicate.getVariable1();
			Conversation anomalousConversation = anomalousCompPredicate.getVariable3();

			ACLMessage msg = new ACLMessage(ACLMessage.INFORM_REF);
			AID receiver = new AID(anomalousComponent.getId(), false);
			msg.setContent(anomalousConversation.getId());
			msg.addReceiver(receiver);
			msg.setConversationId(this.myAgent.getLocalName() + System.currentTimeMillis());
			myAgent.send(msg);
			System.out.println("[" + this.myAgent.getLocalName() + "] Notifying abnormal " + anomalousComponent.getId()
					+ "[" + msg.getContent() + "]");
			//log.info(msg.getConversationId() + "\t" + this.myAgent.getLocalName() + "\t" + msg.getPerformative() + "\t" + anomalousComponent.getId() + "\t" + msg.getContent());
			this.mt = MessageTemplate.and(MessageTemplate.MatchSender(receiver), MessageTemplate.MatchConversationId(msg.getConversationId()));
			this.sent = true;
		} else {
			ACLMessage reply = myAgent.receive(mt);
			if (reply != null) {
				TransientPredicate<AnomalousComponent> anomalousCompBelief = (TransientPredicate<AnomalousComponent>) this
						.getBeliefBase().getBelief(anomalousCompPredicate);
				anomalousCompBelief.setValue(false);
				// UNDO
				this.currentProviders.getValue().replace(anomalousCompPredicate.getVariable2(),
						anomalousCompPredicate.getVariable1());
				System.out.println("[" + this.myAgent.getLocalName() + "]" + reply.getSender().getLocalName() + " is not anomalous anymore!");
				this.sent = false;
				
				if (unavailableProviders != null) {
					if (unavailableProviders.getValue().contains(anomalousCompPredicate.getVariable1())) {
						unavailableProviders.getValue().remove(anomalousCompPredicate.getVariable1());
					}
				}
				setEndState(EndState.SUCCESSFUL);
			} else {
				block();
			}
		}
	}

}
