//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.plan;

import java.util.ArrayList;
import java.util.Map;

import bdi4jade.belief.Belief;
import bdi4jade.belief.TransientPredicate;
import bdi4jade.examples.interactionprotocol.domain.Component;
import bdi4jade.examples.interactionprotocol.domain.LinkMonitor;
import bdi4jade.examples.interactionprotocol.domain.Service;
import bdi4jade.examples.interactionprotocol.domain.predicate.AnomalousLink;
import bdi4jade.goal.PredicateGoal;
import bdi4jade.plan.Plan.EndState;
import bdi4jade.plan.planbody.AbstractPlanBody;

/**
 * @author jgfaccin
 *
 */
public class RepairLinkPlanBody extends AbstractPlanBody {

	private static final long serialVersionUID = 7705669736518583815L;
	
	@bdi4jade.annotation.Belief
	private Belief<String, Map<Service, Component>> currentProviders;
	@bdi4jade.annotation.Belief
	private Belief<String, ArrayList<Component>> unavailableProviders;

	@SuppressWarnings("unchecked")
	@Override
	public void action() {
		if (this.getGoal() instanceof PredicateGoal<?>) {
			PredicateGoal<AnomalousLink> goal = (PredicateGoal<AnomalousLink>) this.getGoal();
			TransientPredicate<AnomalousLink> belief = (TransientPredicate<AnomalousLink>) this.getCapability()
					.getBeliefBase().getBelief(goal.getBeliefName());
			if (belief != null) {
				System.out.println("[" + this.getAgent().getLocalName() + "] Repairing link " + belief.getName().getVariable());
				belief.setValue(false);
				// Remove from link monitor
				LinkMonitor.getInstance().getAnomalousLinks().remove(belief.getName().getVariable());
				// UNDO
				this.currentProviders.getValue().replace(belief.getName().getVariable().getService(),
						belief.getName().getVariable().getTo());
				if (unavailableProviders.getValue().contains(goal.getBeliefName().getVariable().getTo())) {
					unavailableProviders.getValue().remove(goal.getBeliefName().getVariable().getTo());
				}
				setEndState(EndState.SUCCESSFUL);
			}
		}
	}

}
