//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.plan;

import java.time.Instant;
import java.util.Map;

import bdi4jade.belief.Belief;
import bdi4jade.examples.interactionprotocol.Trace;
import bdi4jade.examples.interactionprotocol.dao.TraceDAO;
import bdi4jade.examples.interactionprotocol.domain.Component;
import bdi4jade.examples.interactionprotocol.domain.Service;
import bdi4jade.examples.interactionprotocol.goal.RequestServiceGoal;
import bdi4jade.plan.Plan.EndState;
import bdi4jade.plan.planbody.AbstractPlanBody;
import jade.core.AID;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

/**
 * @author jgfaccin
 *
 */
public class RequestServicePlanBody extends AbstractPlanBody {

	private static final long serialVersionUID = 59990651870691366L;
	//private final Log log = LogFactory.getLog(this.getClass());

	@bdi4jade.annotation.Belief
	private Belief<String, Map<Service, Component>> currentProviders;

	private boolean sent;
	private MessageTemplate mt;
	private Instant sentAt;

	@Override
	public void action() {
		RequestServiceGoal goal = (RequestServiceGoal) this.getGoal();
		Service service = goal.getService();
		if (!sent) {
			String parentCid = goal.getParentCid();

			ACLMessage msg = new ACLMessage(ACLMessage.REQUEST);
			msg.setContent(service.getId());

			Component provider = currentProviders.getValue().get(service);
			msg.addReceiver(new AID(provider.getId(), false));
			msg.setConversationId(this.myAgent.getLocalName() + System.currentTimeMillis());

			myAgent.send(msg);

			setTrace(msg, provider.getId(), parentCid);
			this.mt = MessageTemplate.and(MessageTemplate.MatchConversationId(msg.getConversationId()), MessageTemplate.MatchPerformative(ACLMessage.CONFIRM));
			this.sent = true;
		} else {
			ACLMessage reply = myAgent.receive(mt);
			if (reply != null) {
				goal.setCost(Integer.valueOf(reply.getContent()));
				updateTrace(reply);
				this.sent = false;
				setEndState(EndState.SUCCESSFUL);
			} else {
				block();
			}
		}
	}

	public void setTrace(ACLMessage msg, String receiver, String parentCid) {
		Trace trace = new Trace(msg.getSender().getLocalName(), receiver, msg.getContent(), msg.getConversationId(),
				parentCid);
		this.sentAt = Instant.now();
		trace.setSentAt(this.sentAt.toEpochMilli());

		TraceDAO dao = new TraceDAO(this.getAgent().getAID().getLocalName());
		dao.addTrace(trace);
	}

	public void updateTrace(ACLMessage msg) {
		Instant receivedAt = Instant.now();
		//long delta = Duration.between(this.sentAt, receivedAt).toMillis();
		//log.info("REQUEST\t" + msg.getConversationId() + "\t" + myAgent.getLocalName() + "\t" + msg.getSender().getLocalName() + "\t" + msg.getContent() + "\t" + delta);

		Trace trace = new Trace(this.getAgent().getLocalName(), msg.getSender().getLocalName(), null,
				msg.getConversationId());
		trace.setReceivedAt(receivedAt.toEpochMilli());
		trace.setValue(msg.getContent());

		TraceDAO dao = new TraceDAO(this.getAgent().getAID().getLocalName());
		dao.updateTrace(trace);
	}

	@Override
	public void onStart() {
		super.onStart();
		this.sent = false;
	}

}
