//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.plan;

import bdi4jade.belief.Belief;
import bdi4jade.belief.TransientBelief;
import bdi4jade.examples.interactionprotocol.domain.predicate.Abnormal;
import bdi4jade.goal.PredicateGoal;
import bdi4jade.plan.Plan.EndState;
import bdi4jade.plan.planbody.AbstractPlanBody;

/**
 * @author jgfaccin
 *
 */
public class SelfHealingPlanBody extends AbstractPlanBody {

	private static final long serialVersionUID = 4186257510692528626L;
	
	@bdi4jade.annotation.Belief
	private Belief<String, Boolean> failure;

	@SuppressWarnings("unchecked")
	@Override
	public void action() {
		System.out.println("[" + this.getAgent().getLocalName() + "] Starting SELF-HEALING action...");
		PredicateGoal<Abnormal> goal = (PredicateGoal<Abnormal>) this.getGoal();
		TransientBelief<Abnormal, Boolean> abnormalBehaviourBelief = (TransientBelief<Abnormal, Boolean>) this.getBeliefBase()
				.getBelief(goal.getBeliefName());
		if (abnormalBehaviourBelief == null) {
			abnormalBehaviourBelief = new TransientBelief<Abnormal, Boolean>(goal.getBeliefName(), false);
			this.getBeliefBase().addBelief(abnormalBehaviourBelief);
		} else {
			abnormalBehaviourBelief.setValue(false);
		}
		failure.setValue(false);
		System.out.println("[" + this.getAgent().getLocalName() + "] SELF-HEALING DONE!");
		setEndState(EndState.SUCCESSFUL);
	}

}
