//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.plan;

import java.util.ArrayList;

import bdi4jade.examples.interactionprotocol.domain.Service;
import bdi4jade.plan.planbody.AbstractPlanBody;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;

/**
 * @author jgfaccin
 *
 */
public abstract class YellowPagesPlanBody extends AbstractPlanBody {

	private static final long serialVersionUID = 6856724391696865379L;

	protected ArrayList<DFAgentDescription> getServiceProviders(Service service) {

		ArrayList<DFAgentDescription> descriptions = new ArrayList<DFAgentDescription>();
		DFAgentDescription[] dfAgentDescriptions = new DFAgentDescription[0];

		try {
			DFAgentDescription agentDescription = new DFAgentDescription();
			ServiceDescription serviceDescription = new ServiceDescription();
			serviceDescription.setType(service.getId());
			serviceDescription.setName(service.getId());
			agentDescription.addServices(serviceDescription);

			dfAgentDescriptions = DFService.search(this.myAgent, agentDescription);

			for (DFAgentDescription dfAgentDescription : dfAgentDescriptions) {
				descriptions.add(dfAgentDescription);
			}
		} catch (FIPAException fe) {
			System.err.println("DFService: Error while requesting the DFService!");
		}
		return descriptions;
	}	
}
