//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.examples.interactionprotocol.remedial;

import java.util.ArrayList;

import bdi4jade.core.Capability;
import bdi4jade.core.SingleCapabilityAgent;
import bdi4jade.examples.interactionprotocol.domain.Service;
import jade.domain.DFService;
import jade.domain.FIPAException;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ServiceDescription;

/**
 * @author jgfaccin
 *
 */
public class RemedialServiceProvider extends SingleCapabilityAgent {

	private static final long serialVersionUID = 7910239686830855344L;
	
	private String customName;

	public RemedialServiceProvider(String customName) {
		super();
		this.customName = customName;
	}

	public RemedialServiceProvider(String customName, Capability capability) {
		super(capability);
		this.customName = customName;
	}

	public String getCustomName() {
		return customName;
	}

	public void register() {
		RemedialCapability capability = (RemedialCapability) this.getCapability();
		ArrayList<Service> services = capability.getMyServices();

		DFAgentDescription dfd = new DFAgentDescription();
		dfd.setName(this.getAID());
		for (Service service : services) {
			ServiceDescription sd = new ServiceDescription();
			sd.setType(service.getId());
			sd.setName(service.getId());

			Property property = new Property();
			property.setName(Service.COST);
			
			int cost = capability.getServiceCost().get(service);
			property.setValue(String.valueOf(cost));

			sd.addProperties(property);
			dfd.addServices(sd);
		}
		try {
			DFService.register(this, dfd);
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}
	}

	@Override
	protected void takeDown() {
		try {
			DFService.deregister(this);
		} catch (FIPAException fe) {
			fe.printStackTrace();
		}
		System.out.println("Deregistering from Yellow Page Services.");
		super.takeDown();
	}
	
}
