args = commandArgs(trailingOnly=TRUE)

if (length(args)==0) {
  stop("At least one argument must be supplied (input file).n", call.=FALSE)
}

df = read.table(args[1], header=TRUE)
time = c(df$time)
weights = c(df$weights)
densidade <- density(time, weights = weights)

lowerfence <- quantile(time)[["25%"]] - 1.5 * IQR(time)
upperfence <- quantile(time)[["75%"]] + 1.5 * IQR(time)

f <- approxfun(densidade$x, densidade$y, yleft = 0, yright = 0)
result <- integrate(f, lowerfence, upperfence)$value

write.table(result, file=args[2], row.names = FALSE, col.names = FALSE)
