/*
 * Decompiled with CFR 0.152.
 */
package jade.util.leap;

import jade.util.leap.Serializable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public class Properties
extends java.util.Properties
implements Serializable {
    private static final long serialVersionUID = 3487495895819396L;
    private static final String HEADER = "LEAP-Properties";

    public static Properties toLeapProperties(java.util.Properties pp) {
        if (pp instanceof Properties) {
            return (Properties)pp;
        }
        Properties leapPP = new Properties();
        Enumeration<?> names = pp.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            String value = pp.getProperty(key);
            leapPP.setProperty(key, value);
        }
        return leapPP;
    }

    public void load(String storage) throws IOException {
        this.clear();
        try {
            FileInputStream in = new FileInputStream(storage);
            this.load(in);
            ((InputStream)in).close();
        }
        catch (IOException ioe) {
            InputStream in = ClassLoader.getSystemResourceAsStream(storage);
            if (in == null) {
                throw new IOException("Cannot find file " + storage);
            }
            this.load(in);
            in.close();
        }
    }

    public void store(String storage) throws IOException {
        FileOutputStream out = new FileOutputStream(storage);
        super.store(out, HEADER);
        ((OutputStream)out).close();
    }

    public Object clone() {
        Properties p = new Properties();
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = this.getProperty(key);
            if (value == null) continue;
            p.setProperty(key, value);
        }
        return p;
    }
}

