/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.Concept;
import jade.content.Predicate;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.lang.acl.ACLMessage;
import jade.proto.SimpleAchieveREInitiator;

class RemoteDFRequester
extends SimpleAchieveREInitiator {
    private AID remoteDF;
    private Concept myAction;
    private Object result = null;

    RemoteDFRequester(AID remoteDF, Concept myAction) {
        super(null, null);
        this.remoteDF = remoteDF;
        this.myAction = myAction;
    }

    protected ACLMessage prepareRequest(ACLMessage msg) {
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(this.remoteDF);
        request.setOntology(FIPAManagementOntology.getInstance().getName());
        request.setLanguage("fipa-sl0");
        request.setProtocol("fipa-request");
        Action act = new Action(this.remoteDF, this.myAction);
        try {
            this.myAgent.getContentManager().fillContent(request, act);
            return request;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.result = new InternalError("Error encoding request [" + e.getMessage() + "]");
            return null;
        }
    }

    protected void handleInform(ACLMessage inform) {
        try {
            Predicate p = (Predicate)this.myAgent.getContentManager().extractContent(inform);
            if (p instanceof Result) {
                this.result = ((Result)p).getValue();
            }
        }
        catch (Exception e) {
            this.result = new InternalError("Error decoding response [" + e.getMessage() + "]");
        }
    }

    protected void handleRefuse(ACLMessage refuse) {
        this.result = new InternalError("Agent " + this.remoteDF.getName() + " replyed with " + ACLMessage.getPerformative(refuse.getPerformative()));
    }

    protected void handleNotUnderstood(ACLMessage notUnderstood) {
        this.result = new InternalError("Agent " + this.remoteDF.getName() + " replyed with " + ACLMessage.getPerformative(notUnderstood.getPerformative()));
    }

    protected void handleFailure(ACLMessage failure) {
        this.result = new InternalError("Agent " + this.remoteDF.getName() + " replyed with " + ACLMessage.getPerformative(failure.getPerformative()));
    }

    protected Object getResult() {
        return this.result;
    }

    protected AID getRemoteDF() {
        return this.remoteDF;
    }

    protected Concept getAction() {
        return this.myAction;
    }
}

