/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.core;

import bdi4jade.core.Capability;
import bdi4jade.goal.Goal;
import bdi4jade.plan.Plan;
import jade.lang.acl.ACLMessage;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class PlanLibrary
implements Serializable {
    private static final long serialVersionUID = 3038533629659859857L;
    private Capability capability = null;
    private final Set<Plan> plans = new HashSet<Plan>();

    public PlanLibrary() {
        this(null);
    }

    public PlanLibrary(Set<Plan> plans) {
        if (plans != null) {
            for (Plan plan : plans) {
                this.addPlan(plan);
            }
        }
        this.init();
    }

    public void addPlan(Plan plan) {
        plan.setPlanLibrary(this);
        this.plans.add(plan);
    }

    public Set<Plan> canAchievePlans(Goal goal) {
        HashSet<Plan> plans = new HashSet<Plan>();
        for (Plan plan : this.plans) {
            if (!plan.canAchieve(goal)) continue;
            plans.add(plan);
        }
        return plans;
    }

    public boolean canProcessPlans(ACLMessage message) {
        for (Plan plan : this.plans) {
            if (!plan.canProcess(message)) continue;
            return true;
        }
        return false;
    }

    public Capability getCapability() {
        return this.capability;
    }

    public Set<Plan> getPlans() {
        return this.plans;
    }

    public boolean hasPlan(Plan plan) {
        return this.plans.contains(plan);
    }

    protected void init() {
    }

    public boolean removePlan(Plan plan) {
        boolean removed = this.plans.remove(plan);
        if (removed) {
            plan.setPlanLibrary(null);
        }
        return removed;
    }

    public void setCapability(Capability capability) {
        if (this.capability != null) {
            throw new RuntimeException("PlanLibrary already binded to another capability!");
        }
        this.capability = capability;
        this.init();
    }
}

