/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.examples;

import bdi4jade.examples.BDI4JADEExamplesPanel;
import jade.BootProfileImpl;
import jade.core.Agent;
import jade.core.Profile;
import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.wrapper.AgentContainer;
import jade.wrapper.AgentController;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;

public class BDI4JADEExamplesApp {
    private final BDI4JADEExamplesPanel agentTestPanel;
    private ProfileImpl bootProfile;
    private final Log log = LogFactory.getLog(this.getClass());
    private Runtime runtime;

    public static void main(String[] args) {
        PropertyConfigurator.configure((URL)BDI4JADEExamplesApp.class.getResource("log4j.properties"));
        new BDI4JADEExamplesApp().createAndShowGUI();
    }

    public BDI4JADEExamplesApp() {
        this.agentTestPanel = new BDI4JADEExamplesPanel();
        ArrayList<String> params = new ArrayList<String>();
        params.add("-gui");
        params.add("-detect-main:false");
        this.log.info((Object)("Plataform parameters: " + params));
        this.bootProfile = new BootProfileImpl(params.toArray(new String[0]));
        this.runtime = Runtime.instance();
        AgentContainer controller = this.runtime.createMainContainer((Profile)this.bootProfile);
        Map<String, Agent> agents = this.agentTestPanel.getAgents();
        for (String agentName : agents.keySet()) {
            try {
                AgentController ac = controller.acceptNewAgent(agentName, agents.get(agentName));
                ac.start();
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
    }

    public void createAndShowGUI() {
        final JFrame frame = new JFrame();
        frame.setTitle("BDI4JADE Examples");
        frame.setContentPane(this.agentTestPanel);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
    }
}

