/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.applet;

import jade.content.AgentAction;
import jade.content.abs.AbsContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.domain.DFGUIManagement.DFAppletOntology;
import jade.domain.DFGUIManagement.DeregisterFrom;
import jade.domain.DFGUIManagement.Federate;
import jade.domain.DFGUIManagement.GetDescription;
import jade.domain.DFGUIManagement.GetDescriptionUsed;
import jade.domain.DFGUIManagement.GetParents;
import jade.domain.DFGUIManagement.ModifyOn;
import jade.domain.DFGUIManagement.RegisterWith;
import jade.domain.DFGUIManagement.SearchOn;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.UnsupportedFunction;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.tools.applet.AppletRequestProto;
import jade.tools.applet.DFAppletCommunicator;
import jade.tools.dfgui.DFGUI;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.util.Date;

public class JADEAppletRequestProto
extends AppletRequestProto {
    Codec c;
    String action;
    private static Ontology o = DFAppletOntology.getInstance();
    AID receiver;
    AID parent;
    DFGUI gui;
    DFAppletCommunicator dfApplet;
    ACLMessage lastMsg;

    JADEAppletRequestProto(DFAppletCommunicator communicator, AID receiver, String actionName, Object description, Object parentDF, SearchConstraints constraints) throws FIPAException {
        super(communicator.getStream(), communicator.getParser(), new ACLMessage(16));
        AgentAction action;
        this.gui = communicator.getGUI();
        this.dfApplet = communicator;
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(receiver);
        request.setProtocol("fipa-request");
        request.setLanguage("fipa-sl");
        request.setOntology("DFApplet-Management");
        request.setReplyWith("rw" + new Date().getTime());
        request.setConversationId("conv" + new Date().getTime());
        this.reqMsg = (ACLMessage)request.clone();
        this.action = actionName;
        this.receiver = receiver;
        this.parent = (AID)parentDF;
        Action act = new Action();
        act.setActor(receiver);
        if (actionName.equalsIgnoreCase("federate")) {
            action = new Federate();
            ((Federate)action).setDf((AID)parentDF);
            ((Federate)action).setDescription((DFAgentDescription)description);
            act.setAction(action);
        } else if (actionName.equalsIgnoreCase("getdescription")) {
            act.setAction(new GetDescription());
        } else if (actionName.equalsIgnoreCase("getparents")) {
            act.setAction(new GetParents());
        } else if (actionName.equalsIgnoreCase("getdescriptionused")) {
            action = new GetDescriptionUsed();
            ((GetDescriptionUsed)action).setParentDF((AID)parentDF);
            act.setAction(action);
        } else if (actionName.equalsIgnoreCase("deregisterfrom")) {
            action = new DeregisterFrom();
            ((DeregisterFrom)action).setDf((AID)parentDF);
            ((DeregisterFrom)action).setDescription((DFAgentDescription)description);
            act.setAction(action);
        } else if (actionName.equalsIgnoreCase("registerwith")) {
            action = new RegisterWith();
            ((RegisterWith)action).setDf((AID)parentDF);
            ((RegisterWith)action).setDescription((DFAgentDescription)description);
            act.setAction(action);
        } else if (actionName.equalsIgnoreCase("searchon")) {
            action = new SearchOn();
            ((SearchOn)action).setDf((AID)parentDF);
            ((SearchOn)action).setDescription((DFAgentDescription)description);
            ((SearchOn)action).setConstraints(constraints);
            act.setAction(action);
        } else if (actionName.equalsIgnoreCase("modifyon")) {
            action = new ModifyOn();
            ((ModifyOn)action).setDf((AID)parentDF);
            ((ModifyOn)action).setDescription((DFAgentDescription)description);
            act.setAction(action);
        } else {
            throw new UnsupportedFunction();
        }
        this.c = new SLCodec();
        ArrayList content = new ArrayList();
        content.add(act);
        try {
            String s = ((SLCodec)this.c).encode(o, (AbsContentElement)o.fromObject(act));
            this.reqMsg.setContent(s);
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
            throw new FIPAException("Ontology error: " + oe.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    JADEAppletRequestProto(DFAppletCommunicator communicator, AID receiver, String actionName, Object description, Object parentDF) throws FIPAException {
        this(communicator, receiver, actionName, description, parentDF, null);
    }

    public List getResult() throws FIPAException, NotYetReady {
        if (this.notYetReady) {
            throw new NotYetReady();
        }
        if (this.lastMsg.getPerformative() != 7) {
            throw new FIPAException(this.lastMsg);
        }
        Result r = AppletRequestProto.extractContent(this.lastMsg.getContent(), (SLCodec)this.c, o);
        Iterator i = r.getItems().iterator();
        ArrayList l = new ArrayList();
        while (i.hasNext()) {
            l.add(i.next());
        }
        return l;
    }

    protected void handleAgree(ACLMessage msg) {
        try {
            this.lastMsg = (ACLMessage)msg.clone();
            this.gui.showStatusMsg("Process your request & waiting for result...");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void handleInform(ACLMessage msg) {
        try {
            this.notYetReady = false;
            this.lastMsg = (ACLMessage)msg.clone();
            if (this.action.equalsIgnoreCase("federate")) {
                this.gui.showStatusMsg("Request processed. Ready for new  request.");
                this.gui.addParent(this.parent);
            } else if (this.action.equalsIgnoreCase("getdescription")) {
                try {
                    List result = this.getResult();
                    this.dfApplet.setDescription((DFAgentDescription)result.get(0));
                }
                catch (NotYetReady nyr) {
                    nyr.printStackTrace();
                }
            } else if (this.action.equalsIgnoreCase("getparents")) {
                this.gui.showStatusMsg("Request processed. Ready for new Request.");
            } else if (this.action.equalsIgnoreCase("deregisterfrom")) {
                this.gui.showStatusMsg("Request processed. Ready for a new request");
                this.gui.removeParent(this.parent);
            } else if (this.action.equalsIgnoreCase("registerwith")) {
                this.gui.showStatusMsg("Request processed. Ready for new request.");
            } else if (this.action.equalsIgnoreCase("searchon")) {
                this.gui.refreshLastSearchResults(this.getResult(), this.parent);
                this.gui.showStatusMsg("Request processed. Ready for new request.");
            } else if (this.action.equalsIgnoreCase("modifyon")) {
                this.gui.showStatusMsg("Request processed. Ready for new request.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void handleFailure(ACLMessage msg) {
        try {
            this.notYetReady = false;
            this.lastMsg = (ACLMessage)msg.clone();
            this.gui.showStatusMsg("Request refused.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void handleNotUnderstood(ACLMessage msg) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)msg.clone();
    }

    protected void handleOtherMessage(ACLMessage msg) {
    }

    protected void handleRefuse(ACLMessage msg) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)msg.clone();
    }

    public static class NotYetReady
    extends Exception {
        NotYetReady() {
            super("Requested message is not ready yet.");
        }
    }
}

