package bdi4jade.extension.palliative;

import bdi4jade.annotation.Belief;
import bdi4jade.core.Capability;
import bdi4jade.extension.palliative.graph.CauseEffectKnowledgeModel;
import bdi4jade.extension.palliative.reasoning.PalliativeOptionGenerationFunction;
import bdi4jade.extension.palliative.reasoning.PalliativePlanSelectionStrategy;

public class PalliativeCapability extends Capability {

	private static final long serialVersionUID = -1818834346847016992L;

	@Belief(name = CauseEffectKnowledgeModel.NAME)
	protected CauseEffectKnowledgeModel causeEffectKnowledgeModel = new CauseEffectKnowledgeModel();

	@Belief(name = ResourcePreferences.NAME)
	protected ResourcePreferences preferences = new ResourcePreferences();

	public PalliativeCapability() {
		setOptionGenerationFunction(new PalliativeOptionGenerationFunction(this));
		setPlanSelectionStrategy(new PalliativePlanSelectionStrategy(this));
	}

}
