/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.sl;

import jade.content.abs.AbsPredicate;
import jade.content.lang.sl.SL0Ontology;
import jade.content.lang.sl.SL1Vocabulary;
import jade.content.onto.BasicOntology;
import jade.content.onto.Introspector;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.PredicateSchema;
import jade.core.CaseInsensitiveString;

class SL1Ontology
extends SL0Ontology
implements SL1Vocabulary {
    public static final String ONTOLOGY_NAME = "SL1-ONTOLOGY";
    private static Ontology theInstance = new SL1Ontology("SL1-ONTOLOGY", BasicOntology.getInstance(), null);

    public static Ontology getInstance() {
        return theInstance;
    }

    protected SL1Ontology(String name, Ontology base, Introspector intro) {
        super(name, base, intro);
        try {
            this.add(new PredicateSchema("and"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("or"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("not"), AbsPredicate.getJavaClass());
            PredicateSchema ps = (PredicateSchema)this.getSchema("and");
            ps.add("left", (PredicateSchema)PredicateSchema.getBaseSchema());
            ps.add("right", (PredicateSchema)PredicateSchema.getBaseSchema());
            ps = (PredicateSchema)this.getSchema("or");
            ps.add("left", (PredicateSchema)PredicateSchema.getBaseSchema());
            ps.add("right", (PredicateSchema)PredicateSchema.getBaseSchema());
            ps = (PredicateSchema)this.getSchema("not");
            ps.add("what", (PredicateSchema)PredicateSchema.getBaseSchema());
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
    }

    boolean isUnaryLogicalOp(String symbol) {
        return CaseInsensitiveString.equalsIgnoreCase("not", symbol);
    }

    boolean isBinaryLogicalOp(String symbol) {
        return CaseInsensitiveString.equalsIgnoreCase("and", symbol) || CaseInsensitiveString.equalsIgnoreCase("or", symbol);
    }
}

