package bdi4jade.extension.palliative.graph;

import java.util.ArrayList;
import java.util.List;

import bdi4jade.extension.palliative.logics.Fact;

public class AlternativeCauseSet {

	private List<Fact> alternativeCauses;
	private Integer max;
	private Integer min;

	public AlternativeCauseSet(Integer min, Integer max) {
		setMin(min);
		setMax(max);
		this.alternativeCauses = new ArrayList<>();
	}

	public void addAlternativeCause(Fact cause) {
		this.alternativeCauses.add(cause);
	}

	public List<Fact> getAlternativeCauses() {
		return this.alternativeCauses;
	}

	public Integer getMax() {
		return this.max;
	}

	public Integer getMin() {
		return this.min;
	}

	public void setMax(Integer max) {
		this.max = max;
	}

	public void setMin(Integer min) {
		this.min = min;
	}

}
