//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.extension.palliative.logics;

/**
 * @author ingridnunes
 *
 */
public abstract class BinaryLogicalExpression implements LogicalExpression {

	protected LogicalExpression expression1;
	protected LogicalExpression expression2;

	public BinaryLogicalExpression() {

	}

	public BinaryLogicalExpression(LogicalExpression expression1, LogicalExpression expression2) {
		this.expression1 = expression1;
		this.expression2 = expression2;
	}

	/**
	 * @return the expression1
	 */
	public LogicalExpression getExpression1() {
		return expression1;
	}

	/**
	 * @return the expression2
	 */
	public LogicalExpression getExpression2() {
		return expression2;
	}

	/**
	 * @param expression1
	 *            the expression1 to set
	 */
	public void setExpression1(LogicalExpression expression1) {
		this.expression1 = expression1;
	}

	/**
	 * @param expression2
	 *            the expression2 to set
	 */
	public void setExpression2(LogicalExpression expression2) {
		this.expression2 = expression2;
	}

}
