//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------
package bdi4jade.extension.palliative.logics;

/**
 * @author Ingrid Nunes
 */
public abstract class BinaryPredicate<T, U> extends Predicate {

	private static final long serialVersionUID = -1506723105103606268L;

	protected T variable1;
	protected U variable2;

	public BinaryPredicate() {

	}

	public BinaryPredicate(T first, U second) {
		this.variable1 = first;
		this.variable2 = second;
	}

	protected void appendVariables(StringBuffer sb) {
		sb.append(variable1);
		sb.append(",");
		sb.append(variable2);
	}

	@Override
	public boolean equals(Object obj) {
		if (obj != null && this.getClass().equals(obj.getClass())) {
			BinaryPredicate<?, ?> p = (BinaryPredicate<?, ?>) obj;
			return this.variable1.equals(p.variable1) && this.variable2.equals(p.variable2);
		}
		return false;
	}

	public T getVariable1() {
		return variable1;
	}

	public U getVariable2() {
		return variable2;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.getClass() == null) ? 0 : this.getClass().hashCode());
		result = prime * result + ((variable1 == null) ? 0 : variable1.hashCode());
		result = prime * result + ((variable2 == null) ? 0 : variable2.hashCode());
		return result;
	}

	public void setVariable1(T first) {
		this.variable1 = first;
	}

	public void setVariable2(U second) {
		this.variable2 = second;
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(super.toString());
		sb.append("(");
		appendVariables(sb);
		sb.append(")");
		return sb.toString();
	}

}
