package bdi4jade.extension.palliative.logics;

import java.io.Serializable;

import jade.content.Concept;
import jade.content.ContentElement;

public class Fact implements Serializable, Concept, ContentElement {

	private static final long serialVersionUID = -7208284763130171013L;

	private Predicate proposition;
	private Boolean value;

	public Fact(Predicate proposition, Boolean val) {
		this.proposition = proposition;
		this.value = val;
	}

	public Predicate getPredicate() {
		return proposition;
	}

	public Boolean getValue() {
		return this.value;
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		if (value == null) {
			sb.append("not ");
		} else if (!value) {
			sb.append("~");
		}
		sb.append(proposition);
		return sb.toString();
	}

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof Fact))
			return false;
		Fact other = (Fact) obj;
		return this.proposition.equals(other.proposition) && this.value.equals(other.value);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + proposition.hashCode();
		result = prime * result + value.hashCode();
		return result;
	}

}
