package bdi4jade.extension.palliative.logics;

public abstract class TernaryPredicate<T, U, V> extends BinaryPredicate<T, U> {

	private static final long serialVersionUID = -1506723105103606268L;

	protected V variable3;

	public TernaryPredicate() {

	}

	public TernaryPredicate(T first, U second, V third) {
		super(first, second);
		this.variable3 = third;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj != null && this.getClass().equals(obj.getClass())) {
			TernaryPredicate<?, ?, ?> p = (TernaryPredicate<?, ?, ?>) obj;
			return this.variable1.equals(p.variable1) && this.variable2.equals(p.variable2)
					&& this.variable3.equals(p.variable3);
		}
		return false;
	}

	public V getVariable3() {
		return variable3;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((variable3 == null) ? 0 : variable3.hashCode());
		return result;
	}

	public void setVariable3(V variable3) {
		this.variable3 = variable3;
	}

	protected void appendVariables(StringBuffer sb) {
		super.appendVariables(sb);
		sb.append(",");
		sb.append(variable3);
	}

}