package bdi4jade.extension.palliative.goal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import bdi4jade.extension.palliative.Resource;
import bdi4jade.extension.palliative.logics.LogicalExpression;
import bdi4jade.goal.Goal;
import bdi4jade.goal.NestedGoal;

public class ConstrainedGoal extends NestedGoal {

	private static final long serialVersionUID = -7779648429437829445L;

	private Map<Resource, ObjectiveFunction> objectiveFunction;
	private Set<LogicalExpression> operationConstraints;

	public ConstrainedGoal(Goal goal) {
		super(goal);
		this.operationConstraints = new HashSet<>();
		this.objectiveFunction = new HashMap<>();
	}

	public void addObjectiveFunction(Resource resource, ObjectiveFunction objectiveFunction) {
		this.objectiveFunction.put(resource, objectiveFunction);
	}

	public void addOperationConstraint(LogicalExpression constraint) {
		this.operationConstraints.add(constraint);
	}

	public Map<Resource, ObjectiveFunction> getObjectiveFunction() {
		return objectiveFunction;
	}

	public ObjectiveFunction getObjectiveFunction(Resource resource) {
		return this.objectiveFunction.get(resource);
	}

	public Set<LogicalExpression> getOperationConstraints() {
		return operationConstraints;
	}

	public void setObjectiveFunction(Map<Resource, ObjectiveFunction> objectiveFunction) {
		this.objectiveFunction = objectiveFunction;
	}

	public void setOperationConstraints(Set<LogicalExpression> operationConstraints) {
		this.operationConstraints = operationConstraints;
	}

}
