package bdi4jade.extension.palliative.graph;

import java.util.HashMap;
import java.util.Map;

import bdi4jade.belief.TransientBelief;
import bdi4jade.extension.palliative.logics.Fact;
import bdi4jade.extension.palliative.logics.Predicate;
import bdi4jade.goal.BeliefValueGoal;
import bdi4jade.goal.Goal;
import bdi4jade.goal.PredicateGoal;

public class CauseEffectKnowledgeModel extends TransientBelief<String, Map<Fact, CauseEffectRelationship>> {

	public static final String NAME = "CauseEffectModel";

	public CauseEffectKnowledgeModel() {
		super(NAME, new HashMap<>());
	}

	public void addCauseEffectRelationship(CauseEffectRelationship causes) {
		this.getValue().put(causes.getEffect(), causes);
	}

	public CauseEffectRelationship getCauseEffectRelationship(Goal goal) {
		if (goal instanceof PredicateGoal<?>) {
			PredicateGoal<? extends Predicate> bgoal = (PredicateGoal<? extends Predicate>) goal;
			Fact fact = new Fact(bgoal.getBeliefName(), !bgoal.getValue());
			return getCausesOf(fact);
		}
		return null;
	}

	public CauseEffectRelationship getCausesOf(Fact effect) {
		return this.getValue().get(effect);
	}

	public boolean isEffect(Fact fact) {
		return getValue().containsKey(fact);
	}

}
