package bdi4jade.extension.palliative.graph;

import java.util.ArrayList;
import java.util.List;

import bdi4jade.extension.palliative.logics.Fact;

public class CauseEffectRelationship {

	private List<AlternativeCauseSet> alternativeCauseSets;
	private Fact effect;
	private List<Fact> mandatoryCauses;
	private List<Fact> optionalCauses;

	public CauseEffectRelationship(Fact effect) {
		this.effect = effect;
		this.mandatoryCauses = new ArrayList<>();
		this.optionalCauses = new ArrayList<>();
		this.alternativeCauseSets = new ArrayList<>();
	}

	public void addAlternativeCauseSet(AlternativeCauseSet acs) {
		this.alternativeCauseSets.add(acs);
	}

	public void addMandatoryCause(Fact cause) {
		this.mandatoryCauses.add(cause);
	}

	public void addOptionalCause(Fact cause) {
		this.optionalCauses.add(cause);
	}

	public List<Fact> getAllPossibleCauses() {
		ArrayList<Fact> possibleCauses = new ArrayList<>();
		possibleCauses.addAll(mandatoryCauses);
		possibleCauses.addAll(optionalCauses);
		possibleCauses.addAll(getAlternativeCauses());
		return possibleCauses;
	}

	public List<Fact> getAlternativeCauses() {
		ArrayList<Fact> alternativeCauses = new ArrayList<>();
		for (AlternativeCauseSet causeSet : this.alternativeCauseSets) {
			alternativeCauses.addAll(causeSet.getAlternativeCauses());
		}
		return alternativeCauses;
	}

	public List<AlternativeCauseSet> getAlternativeCauseSets() {
		return this.alternativeCauseSets;
	}

	public Fact getEffect() {
		return effect;
	}

	public List<Fact> getMandatoryCauses() {
		return this.mandatoryCauses;
	}

	public List<Fact> getOptionalCauses() {
		return this.optionalCauses;
	}
}
