//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------

package bdi4jade.extension.palliative.logics;

import java.util.Map;

import bdi4jade.belief.BeliefBase;

/**
 * @author ingridnunes
 *
 */
public class Not extends UnaryLogicalExpression {

	public Not() {

	}

	public Not(LogicalExpression expression) {
		super(expression);
	}

	@Override
	public Boolean getValue(BeliefBase beliefBase) {
		return !getExpression().getValue(beliefBase);
	}

	@Override
	public Boolean getValue(Map<Object, Object> values) {
		return !getExpression().getValue(values);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("!").append(expression);
		return sb.toString();
	}

}
