//----------------------------------------------------------------------------
// Copyright (C) 2011  Ingrid Nunes
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// To contact the authors:
// http://inf.ufrgs.br/prosoft/bdi4jade/
//
//----------------------------------------------------------------------------
package bdi4jade.extension.palliative.logics;

import java.util.Map;

import bdi4jade.belief.BeliefBase;
import bdi4jade.belief.PredicateBelief;

/**
 * @author Ingrid Nunes
 */
public abstract class UnaryPredicate<T> extends Predicate {

	private static final long serialVersionUID = -1506723105103606268L;

	protected T variable;

	public UnaryPredicate() {

	}

	public UnaryPredicate(T concept) {
		this.variable = concept;
	}

	protected void appendVariables(StringBuffer sb) {
		sb.append(variable);
	}

	@Override
	public boolean equals(Object obj) {
		if (obj != null && this.getClass().equals(obj.getClass())) {
			UnaryPredicate<?> p = (UnaryPredicate<?>) obj;
			return this.variable.equals(p.variable);
		}
		return false;
	}

	@Override
	public Boolean getValue(BeliefBase beliefBase) {
		PredicateBelief<Predicate> belief = (PredicateBelief<Predicate>) beliefBase.getBelief(this);
		if (belief != null) {
			return belief.getValue();
		}
		return null;
	}

	@Override
	public Boolean getValue(Map<Object, Object> values) {
		return (Boolean) values.get(this);
	}

	public T getVariable() {
		return variable;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.getClass() == null) ? 0 : this.getClass().hashCode());
		result = prime * result + ((variable == null) ? 0 : variable.hashCode());
		return result;
	}

	public void setConcept(T concept) {
		this.variable = concept;
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(super.toString());
		sb.append("(");
		appendVariables(sb);
		sb.append(")");
		return sb.toString();
	}

}
