/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.ClassDiscovery;
import weka.core.Javadoc;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class OptionHandlerJavadoc
extends Javadoc {
    public static final String OPTIONS_STARTTAG = "<!-- options-start -->";
    public static final String OPTIONS_ENDTAG = "<!-- options-end -->";
    protected boolean m_Prolog = true;

    public OptionHandlerJavadoc() {
        this.m_StartTag = new String[1];
        this.m_EndTag = new String[1];
        this.m_StartTag[0] = OPTIONS_STARTTAG;
        this.m_EndTag[0] = OPTIONS_ENDTAG;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addAll(Collections.list(super.listOptions()));
        result.addElement(new Option("\tSuppresses the 'Valid options are...' prolog in the Javadoc.", "noprolog", 0, "-noprolog"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        this.setProlog(!Utils.getFlag("noprolog", options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        Collections.addAll(result, super.getOptions());
        if (!this.getProlog()) {
            result.add("-noprolog");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setProlog(boolean value) {
        this.m_Prolog = value;
    }

    public boolean getProlog() {
        return this.m_Prolog;
    }

    @Override
    protected String generateJavadoc(int index) throws Exception {
        String result = "";
        if (index == 0) {
            if (!this.canInstantiateClass()) {
                return result;
            }
            if (!ClassDiscovery.hasInterface(OptionHandler.class, this.getInstance().getClass())) {
                throw new Exception("Class '" + this.getClassname() + "' is not an OptionHandler!");
            }
            OptionHandler handler = (OptionHandler)this.getInstance();
            Enumeration<Option> enm = handler.listOptions();
            if (!enm.hasMoreElements()) {
                return result;
            }
            if (this.getProlog()) {
                result = "Valid options are: <p/>\n\n";
            }
            enm = handler.listOptions();
            while (enm.hasMoreElements()) {
                Option option = enm.nextElement();
                String optionStr = this.toHTML(option.synopsis()) + "\n" + this.toHTML(option.description().replaceAll("\\t", " "));
                result = result + "<pre> " + optionStr.replaceAll("<br/>", "") + "</pre>\n\n";
            }
            if (this.getUseStars()) {
                result = this.indent(result, 1, "* ");
            }
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }

    public static void main(String[] args) {
        OptionHandlerJavadoc.runJavadoc(new OptionHandlerJavadoc(), args);
    }
}

