/*
 * Decompiled with CFR 0.152.
 */
package jade.core.replication;

import jade.core.Agent;
import jade.core.ServiceNotActiveException;
import jade.core.replication.AgentReplicationHelper;
import jade.util.Logger;

public class AgentReplicationHandle {
    static ThreadLocal<Boolean> replicatedCalls = new ThreadLocal();
    private static Logger myLogger = Logger.getJADELogger(AgentReplicationHandle.class.getName());

    public static void replicate(Agent a, String methodName, Object[] arguments) {
        if (AgentReplicationHandle.isReplicatedCall()) {
            return;
        }
        try {
            AgentReplicationHelper helper = (AgentReplicationHelper)a.getHelper("jade.core.replication.AgentReplication");
            helper.invokeReplicatedMethod(methodName, arguments);
        }
        catch (ServiceNotActiveException snae) {
        }
        catch (Exception e) {
            myLogger.log(Logger.WARNING, "Error accessing replication helper of agent " + a.getLocalName(), e);
        }
    }

    public static boolean isReplicatedCall() {
        Boolean b = replicatedCalls.get();
        return b != null && b != false;
    }

    static void enterReplicatedCall() {
        if (myLogger.isLoggable(Logger.FINER)) {
            myLogger.log(Logger.FINER, "Entering replicated call...");
        }
        replicatedCalls.set(true);
    }

    static void exitReplicatedCall() {
        replicatedCalls.remove();
        if (myLogger.isLoggable(Logger.FINER)) {
            myLogger.log(Logger.FINER, "Exited from replicated call...");
        }
    }
}

