/*
 * Decompiled with CFR 0.152.
 */
package jade.content.schema;

import jade.content.abs.AbsIRE;
import jade.content.abs.AbsObject;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.ContentElementSchema;
import jade.content.schema.ObjectSchema;
import jade.content.schema.PredicateSchema;
import jade.content.schema.TermSchema;

public class IRESchema
extends TermSchema {
    public static final String BASE_NAME = "IRE";
    private static IRESchema baseSchema = new IRESchema();
    public static final String VARIABLE = "Variable";
    public static final String PROPOSITION = "Proposition";

    private IRESchema() {
        super(BASE_NAME);
    }

    public IRESchema(String typeName) {
        super(typeName);
        this.add(VARIABLE, TermSchema.getBaseSchema());
        this.add(PROPOSITION, PredicateSchema.getBaseSchema());
    }

    public static ObjectSchema getBaseSchema() {
        return baseSchema;
    }

    public AbsObject newInstance() throws OntologyException {
        return new AbsIRE(this.getTypeName());
    }

    public void validate(AbsObject abs, Ontology onto) throws OntologyException {
        if (!(abs instanceof AbsIRE)) {
            throw new OntologyException(abs + " is not an AbsIRE");
        }
        this.validateSlots(abs, onto);
    }

    public boolean isCompatibleWith(ObjectSchema s) {
        if (s != null) {
            return s.descendsFrom(TermSchema.getBaseSchema());
        }
        return false;
    }

    protected boolean descendsFrom(ObjectSchema s) {
        if (s != null) {
            if (s.equals(IRESchema.getBaseSchema())) {
                return true;
            }
            if (super.descendsFrom(s)) {
                return true;
            }
            return ContentElementSchema.getBaseSchema().descendsFrom(s);
        }
        return false;
    }
}

