/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.sl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class SLFormatter {
    static String spacing = "\n                                                                   ";
    private static final int INDENT_EXPRESSION = 2;
    private static final int INDENT_ARGUMENT = 2;
    private static final int SHORT_EXPRESSION_LENGTH = 40;

    public static String format(String s) {
        return SLFormatter.format(new myStringIterator(s), 0);
    }

    private static String format(myStringIterator src, int indentation) {
        StringBuffer result = new StringBuffer();
        int previous = 0;
        int indentStep = 2;
        boolean insideQuote = false;
        while (src.hasNext()) {
            char current = src.next();
            if (insideQuote) {
                result.append(current);
            } else {
                switch (current) {
                    case ':': {
                        if (previous == 32 || previous == 10 || previous == 13) {
                            indentStep = 4;
                            result.append(spacing.substring(0, indentation + 2));
                        }
                        result.append(current);
                        break;
                    }
                    case '(': {
                        String expression = SLFormatter.format(src, indentation + indentStep).trim();
                        String indentSpacing = "";
                        if (expression.length() > 40) {
                            indentSpacing = spacing.substring(0, indentation + indentStep);
                        }
                        result.append(indentSpacing + '(' + expression + ')');
                        break;
                    }
                    case ')': {
                        return result.toString();
                    }
                    case '\n': 
                    case '\r': {
                        break;
                    }
                    default: {
                        result.append(current);
                    }
                }
            }
            if (current == '\"' && previous != 92) {
                insideQuote = !insideQuote;
            }
            previous = current;
        }
        return result.toString();
    }

    public static void main(String[] args) {
        try {
            BufferedReader buff = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                System.out.println("\ninsert an SL0 expression to format: ");
                String inp = buff.readLine();
                System.out.println(SLFormatter.format(inp));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private static class myStringIterator {
        public String string;
        public int index;

        myStringIterator(String s) {
            this.string = s;
            this.index = 0;
        }

        char next() {
            return this.string.charAt(this.index++);
        }

        boolean hasNext() {
            return this.index < this.string.length();
        }
    }
}

