/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.proto.SSResponder;
import jade.proto.states.ReplySender;

public class SSIteratedAchieveREResponder
extends SSResponder {
    public final String REQUEST_KEY;
    public final String CANCEL_KEY;
    public static final String HANDLE_REQUEST = "Handle-Request";
    public static final String HANDLE_CANCEL = "Handle-Cancel";
    static final String ACL_USERDEF_TERMINATED_SESSION = "iterated-fipa-request-terminated-session";
    private boolean sessionClosed;
    private int initiationPerformative;

    public SSIteratedAchieveREResponder(Agent a, ACLMessage request) {
        this(a, request, new DataStore());
    }

    public SSIteratedAchieveREResponder(Agent a, ACLMessage request, DataStore store) {
        super(a, request, store, false);
        this.REQUEST_KEY = this.RECEIVED_KEY;
        this.CANCEL_KEY = this.RECEIVED_KEY;
        this.sessionClosed = false;
        this.initiationPerformative = request.getPerformative();
        this.registerDefaultTransition(HANDLE_REQUEST, "Send-Reply");
        this.registerTransition("Send-Reply", "Receive-Next", 7);
        this.registerTransition("Receive-Next", HANDLE_CANCEL, -1001);
        this.registerTransition("Check-In-seq", HANDLE_REQUEST, this.initiationPerformative, new String[]{HANDLE_REQUEST, "Send-Reply", "Receive-Next", "Check-In-seq"});
        this.registerTransition("Check-In-seq", HANDLE_CANCEL, 2);
        this.registerDefaultTransition(HANDLE_CANCEL, "Dummy-Final");
        OneShotBehaviour b = new RequestHandler(this.myAgent);
        this.registerFirstState(b, HANDLE_REQUEST);
        b.setDataStore(this.getDataStore());
        b = new CancelHandler(this.myAgent);
        this.registerDSState(b, HANDLE_CANCEL);
    }

    protected ACLMessage handleRequest(ACLMessage request) throws RefuseException, FailureException, NotUnderstoodException {
        return null;
    }

    protected void handleCancel(ACLMessage cancel) {
    }

    public void registerHandleRequest(Behaviour b) {
        this.registerFirstState(b, HANDLE_REQUEST);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleCancel(Behaviour b) {
        this.registerDSState(b, HANDLE_CANCEL);
    }

    public void sendAgree(ACLMessage agree) {
        agree.setPerformative(1);
        ReplySender.adjustReply(this.myAgent, agree, (ACLMessage)this.getDataStore().get(this.REQUEST_KEY));
        this.myAgent.send(agree);
    }

    public void closeSessionOnNextReply() {
        this.sessionClosed = true;
    }

    public void reset() {
        this.sessionClosed = false;
        super.reset();
    }

    protected boolean checkInSequence(ACLMessage received) {
        return received.getPerformative() == this.initiationPerformative || received.getPerformative() == 2;
    }

    protected void beforeReply(ACLMessage reply) {
        if (this.sessionClosed && reply != null) {
            reply.addUserDefinedParameter(ACL_USERDEF_TERMINATED_SESSION, String.valueOf(true));
            this.forceTransitionTo("Dummy-Final");
        }
    }

    private static class CancelHandler
    extends OneShotBehaviour {
        private static final long serialVersionUID = 5463827646358002L;

        public CancelHandler(Agent a) {
            super(a);
        }

        public void action() {
            SSIteratedAchieveREResponder parent = (SSIteratedAchieveREResponder)this.getParent();
            parent.handleCancel((ACLMessage)this.getDataStore().get(parent.CANCEL_KEY));
        }
    }

    private static class RequestHandler
    extends OneShotBehaviour {
        private static final long serialVersionUID = 5463827646358001L;

        public RequestHandler(Agent a) {
            super(a);
        }

        public void action() {
            SSIteratedAchieveREResponder parent = (SSIteratedAchieveREResponder)this.getParent();
            ACLMessage reply = null;
            try {
                reply = parent.handleRequest((ACLMessage)this.getDataStore().get(parent.REQUEST_KEY));
            }
            catch (FIPAException fe) {
                reply = fe.getACLMessage();
            }
            this.getDataStore().put(parent.REPLY_KEY, reply);
        }
    }
}

