/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.SimpleBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import jade.util.leap.Iterator;
import java.util.Date;
import java.util.Vector;

public class SimpleAchieveREInitiator
extends SimpleBehaviour {
    private static final int PREPARE_MSG_STATE = 0;
    private static final int SEND_MSG_STATE = 1;
    private static final int RECEIVE_REPLY_STATE = 2;
    private static final int RECEIVE_2ND_REPLY_STATE = 3;
    private static final int ALL_REPLIES_RECEIVED_STATE = 4;
    private static final int ALL_RESULT_NOTIFICATION_RECEIVED_STATE = 5;
    public final String REQUEST_KEY = "_request" + this.hashCode();
    public final String REQUEST_SENT_KEY = "_request_sent" + this.hashCode();
    public final String SECOND_REPLY_KEY = "_2nd_reply" + this.hashCode();
    public final String ALL_RESPONSES_KEY = "_all-responses" + this.hashCode();
    public final String ALL_RESULT_NOTIFICATIONS_KEY = "_all-result-notification" + this.hashCode();
    private MessageTemplate mt = null;
    private int state = 0;
    private boolean finished;
    private long timeout = -1L;
    private long endingTime = 0L;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    public SimpleAchieveREInitiator(Agent a, ACLMessage msg) {
        this(a, msg, new DataStore());
    }

    public SimpleAchieveREInitiator(Agent a, ACLMessage msg, DataStore store) {
        super(a);
        this.setDataStore(store);
        this.getDataStore().put(this.REQUEST_KEY, msg);
        this.finished = false;
    }

    public final void action() {
        block0 : switch (this.state) {
            case 0: {
                ACLMessage msg = this.prepareRequest((ACLMessage)this.getDataStore().get(this.REQUEST_KEY));
                this.getDataStore().put(this.REQUEST_SENT_KEY, msg);
                this.state = 1;
                break;
            }
            case 1: {
                Date d;
                DataStore ds = this.getDataStore();
                String conversationID = null;
                ACLMessage request = (ACLMessage)ds.get(this.REQUEST_SENT_KEY);
                if (request == null) {
                    this.finished = true;
                    break;
                }
                if (request.getConversationId() == null) {
                    conversationID = "C" + this.hashCode() + "_" + System.currentTimeMillis();
                    request.setConversationId(conversationID);
                } else {
                    conversationID = request.getConversationId();
                }
                this.mt = MessageTemplate.MatchConversationId(conversationID);
                Iterator receivers = request.getAllReceiver();
                AID r = (AID)receivers.next();
                request.clearAllReceiver();
                request.addReceiver(r);
                if (receivers.hasNext() && this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "The message you are sending has more than one receivers. The message will be sent only to the first one !!");
                }
                if (r.equals(this.myAgent.getAID())) {
                    this.mt = MessageTemplate.and(this.mt, MessageTemplate.not(MessageTemplate.MatchCustom(request, true)));
                }
                this.timeout = (d = request.getReplyByDate()) != null ? d.getTime() - new Date().getTime() : -1L;
                this.endingTime = System.currentTimeMillis() + this.timeout;
                this.myAgent.send(request);
                this.state = 2;
                break;
            }
            case 2: {
                ACLMessage firstReply = this.myAgent.receive(this.mt);
                if (firstReply != null) {
                    DataStore ds = this.getDataStore();
                    switch (firstReply.getPerformative()) {
                        case 1: {
                            this.state = 3;
                            Vector allResp = (Vector)ds.get(this.ALL_RESPONSES_KEY);
                            allResp.addElement(firstReply);
                            this.handleAgree(firstReply);
                            this.handleAllResponses((Vector)this.getDataStore().get(this.ALL_RESPONSES_KEY));
                            break block0;
                        }
                        case 14: {
                            Vector allResp = (Vector)ds.get(this.ALL_RESPONSES_KEY);
                            allResp.addElement(firstReply);
                            this.state = 4;
                            this.handleRefuse(firstReply);
                            break block0;
                        }
                        case 10: {
                            Vector allResp = (Vector)ds.get(this.ALL_RESPONSES_KEY);
                            allResp.addElement(firstReply);
                            this.state = 4;
                            this.handleNotUnderstood(firstReply);
                            break block0;
                        }
                        case 6: {
                            Vector allResNot = (Vector)ds.get(this.ALL_RESULT_NOTIFICATIONS_KEY);
                            allResNot.addElement(firstReply);
                            this.state = 5;
                            this.handleFailure(firstReply);
                            break block0;
                        }
                        case 7: {
                            Vector allResNot = (Vector)ds.get(this.ALL_RESULT_NOTIFICATIONS_KEY);
                            allResNot.addElement(firstReply);
                            this.state = 5;
                            this.handleInform(firstReply);
                            break block0;
                        }
                    }
                    this.state = 2;
                    this.handleOutOfSequence(firstReply);
                    break;
                }
                if (this.timeout > 0L) {
                    long blockTime = this.endingTime - System.currentTimeMillis();
                    if (blockTime <= 0L) {
                        this.state = 4;
                        break;
                    }
                    this.block(blockTime);
                    break;
                }
                this.block();
                break;
            }
            case 3: {
                ACLMessage secondReply = this.myAgent.receive(this.mt);
                if (secondReply != null) {
                    DataStore ds = this.getDataStore();
                    switch (secondReply.getPerformative()) {
                        case 7: {
                            this.state = 5;
                            Vector allResNot = (Vector)ds.get(this.ALL_RESULT_NOTIFICATIONS_KEY);
                            allResNot.addElement(secondReply);
                            this.handleInform(secondReply);
                            break block0;
                        }
                        case 6: {
                            this.state = 5;
                            Vector allResNot = (Vector)ds.get(this.ALL_RESULT_NOTIFICATIONS_KEY);
                            allResNot.addElement(secondReply);
                            this.handleFailure(secondReply);
                            break block0;
                        }
                    }
                    this.state = 2;
                    this.handleOutOfSequence(secondReply);
                    break;
                }
                this.block();
                break;
            }
            case 4: {
                this.state = 5;
                this.handleAllResponses((Vector)this.getDataStore().get(this.ALL_RESPONSES_KEY));
                break;
            }
            case 5: {
                this.finished = true;
                this.handleAllResultNotifications((Vector)this.getDataStore().get(this.ALL_RESULT_NOTIFICATIONS_KEY));
                break;
            }
        }
    }

    public void onStart() {
        this.initializeDataStore();
    }

    public boolean done() {
        return this.finished;
    }

    protected ACLMessage prepareRequest(ACLMessage msg) {
        return msg;
    }

    protected void handleAgree(ACLMessage msg) {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "in HandleAgree: " + msg.toString());
        }
    }

    protected void handleRefuse(ACLMessage msg) {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "in HandleRefuse: " + msg.toString());
        }
    }

    protected void handleNotUnderstood(ACLMessage msg) {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "in HandleNotUnderstood: " + msg.toString());
        }
    }

    protected void handleInform(ACLMessage msg) {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "in HandleInform: " + msg.toString());
        }
    }

    protected void handleFailure(ACLMessage msg) {
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, "in HandleFailure: " + msg.toString());
        }
    }

    protected void handleOutOfSequence(ACLMessage msg) {
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, "in HandleOutOfSequence: " + msg.toString());
        }
    }

    protected void handleAllResponses(Vector msgs) {
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, this.myAgent.getName() + "in handleAllResponses: ");
        }
    }

    protected void handleAllResultNotifications(Vector msgs) {
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, this.myAgent.getName() + "in HandleAllResultNotification: ");
        }
    }

    public void reset() {
        this.reset(null);
    }

    public void reset(ACLMessage msg) {
        this.finished = false;
        this.state = 0;
        this.getDataStore().put(this.REQUEST_KEY, msg);
        this.initializeDataStore();
        super.reset();
    }

    private void initializeDataStore() {
        Vector l = new Vector();
        this.getDataStore().put(this.ALL_RESPONSES_KEY, l);
        l = new Vector();
        this.getDataStore().put(this.ALL_RESULT_NOTIFICATIONS_KEY, l);
    }
}

