/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.plan;

import bdi4jade.core.Capability;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalTemplateFactory;
import bdi4jade.goal.ParallelGoal;
import bdi4jade.goal.SequentialGoal;
import bdi4jade.plan.DefaultPlan;
import bdi4jade.plan.Plan;
import bdi4jade.plan.planbody.ParallelGoalPlanBody;
import bdi4jade.plan.planbody.SequentialGoalPlanBody;
import jade.lang.acl.ACLMessage;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class PlanLibrary
implements Serializable {
    private static final long serialVersionUID = 3038533629659859857L;
    private Capability capability;
    private final Set<Plan> plans;

    protected PlanLibrary() {
        this.plans = new HashSet<Plan>();
    }

    public PlanLibrary(Capability capability) {
        this(capability, null);
    }

    public PlanLibrary(Capability capability, Set<Plan> plans) {
        if (capability == null) {
            throw new NullPointerException("Capability must be not null.");
        }
        this.capability = capability;
        this.plans = new HashSet<Plan>();
        if (plans != null) {
            for (Plan plan : plans) {
                this.addPlan(plan);
            }
        }
        this.addDefaultPlans();
    }

    protected void addDefaultPlans() {
        this.addPlan(new DefaultPlan(GoalTemplateFactory.goalOfType(SequentialGoal.class), SequentialGoalPlanBody.class));
        this.addPlan(new DefaultPlan(GoalTemplateFactory.goalOfType(ParallelGoal.class), ParallelGoalPlanBody.class));
    }

    public void addPlan(Plan plan) {
        if (plan.getPlanLibrary() != null) {
            plan.getPlanLibrary().removePlan(plan);
        }
        plan.setPlanLibrary(this);
        this.plans.add(plan);
    }

    public boolean canAchieve(Goal goal) {
        for (Plan plan : this.plans) {
            if (!plan.canAchieve(goal)) continue;
            return true;
        }
        return false;
    }

    public boolean canHandle(ACLMessage message) {
        for (Plan plan : this.plans) {
            if (!plan.canProcess(message)) continue;
            return true;
        }
        return false;
    }

    public Set<Plan> getCandidatePlans(Goal goal) {
        HashSet<Plan> plans = new HashSet<Plan>();
        for (Plan plan : this.plans) {
            if (!plan.canAchieve(goal)) continue;
            plans.add(plan);
        }
        return plans;
    }

    public Capability getCapability() {
        return this.capability;
    }

    public Set<Plan> getPlans() {
        return this.plans;
    }

    public boolean hasPlan(Plan plan) {
        return this.plans.contains(plan);
    }

    public boolean removePlan(Plan plan) {
        boolean removed = this.plans.remove(plan);
        if (removed) {
            plan.setPlanLibrary(null);
        }
        return removed;
    }
}

