/*
 * Decompiled with CFR 0.152.
 */
package bdi4jade.core;

import bdi4jade.belief.Belief;
import bdi4jade.core.BDIAgent;
import bdi4jade.core.Capability;
import bdi4jade.core.GoalUpdateSet;
import bdi4jade.core.Intention;
import bdi4jade.event.GoalEvent;
import bdi4jade.event.GoalListener;
import bdi4jade.goal.Goal;
import bdi4jade.goal.GoalStatus;
import bdi4jade.goal.Softgoal;
import bdi4jade.message.BDIAgentMsgReceiver;
import bdi4jade.reasoning.AgentBeliefRevisionStrategy;
import bdi4jade.reasoning.AgentDeliberationFunction;
import bdi4jade.reasoning.AgentOptionGenerationFunction;
import bdi4jade.reasoning.AgentPlanSelectionStrategy;
import bdi4jade.reasoning.DefaultAgentBeliefRevisionStrategy;
import bdi4jade.reasoning.DefaultAgentDeliberationFunction;
import bdi4jade.reasoning.DefaultAgentOptionGenerationFunction;
import bdi4jade.reasoning.DefaultAgentPlanSelectionStrategy;
import bdi4jade.util.ReflectionUtils;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.lang.acl.ACLMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractBDIAgent
extends Agent
implements BDIAgent {
    private static final Log log = LogFactory.getLog(AbstractBDIAgent.class);
    private static final long serialVersionUID = -841774495336214256L;
    private final Collection<Intention> agentIntentions;
    private final Set<Capability> aggregatedCapabilities;
    private final Map<Goal, Intention> allIntentions;
    private final BDIInterpreter bdiInterpreter = new BDIInterpreter(this);
    private AgentBeliefRevisionStrategy beliefRevisionStrategy;
    private Set<Capability> capabilities = new HashSet<Capability>();
    private AgentDeliberationFunction deliberationFunction;
    protected final List<GoalListener> goalListeners;
    private AgentOptionGenerationFunction optionGenerationFunction;
    private AgentPlanSelectionStrategy planSelectionStrategy;
    private Map<Class<? extends Capability>, Set<Capability>> restrictedAccessOwnersMap = new HashMap<Class<? extends Capability>, Set<Capability>>();
    private final Set<Softgoal> softgoals;

    public AbstractBDIAgent() {
        this.allIntentions = new HashMap<Goal, Intention>();
        this.aggregatedCapabilities = new HashSet<Capability>();
        this.agentIntentions = new LinkedList<Intention>();
        this.softgoals = new HashSet<Softgoal>();
        this.goalListeners = new LinkedList<GoalListener>();
        this.setBeliefRevisionStrategy(null);
        this.setOptionGenerationFunction(null);
        this.setDeliberationFunction(null);
        this.setPlanSelectionStrategy(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCapability(Capability capability) {
        Set<Capability> set = this.aggregatedCapabilities;
        synchronized (set) {
            this.aggregatedCapabilities.add(capability);
            this.resetAllCapabilities();
            this.computeGoalOwnersMap();
        }
    }

    @Override
    public final boolean addGoal(Capability dispatcher, Goal goal) {
        try {
            this.addIntention(dispatcher, goal, null);
            return true;
        }
        catch (IllegalAccessException exc) {
            log.error((Object)exc);
            return false;
        }
    }

    @Override
    public final boolean addGoal(Capability dispatcher, Goal goal, GoalListener goalListener) {
        try {
            this.addIntention(dispatcher, goal, goalListener);
            return true;
        }
        catch (IllegalAccessException exc) {
            log.error((Object)exc);
            return false;
        }
    }

    @Override
    public final boolean addGoal(Goal goal) {
        try {
            this.addIntention(null, goal, null);
            return true;
        }
        catch (IllegalAccessException exc) {
            log.error((Object)exc);
            return false;
        }
    }

    @Override
    public final boolean addGoal(Goal goal, GoalListener goalListener) {
        try {
            this.addIntention(null, goal, goalListener);
            return true;
        }
        catch (IllegalAccessException exc) {
            log.error((Object)exc);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addGoalListener(GoalListener goalListener) {
        List<GoalListener> list = this.goalListeners;
        synchronized (list) {
            this.goalListeners.add(goalListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Intention addIntention(Capability dispatcher, Goal goal, GoalListener goalListener) throws IllegalAccessException {
        Intention intention = null;
        Map<Goal, Intention> map = this.allIntentions;
        synchronized (map) {
            block8: {
                intention = this.allIntentions.get(goal);
                if (intention == null) break block8;
                log.info((Object)("This agent already has goal: " + goal));
                if (goalListener != null) {
                    intention.addGoalListener(goalListener);
                }
                return null;
            }
            intention = new Intention(goal, this, dispatcher);
            this.allIntentions.put(goal, intention);
            if (dispatcher == null) {
                this.agentIntentions.add(intention);
            } else {
                dispatcher.addIntention(intention);
            }
            if (goalListener != null) {
                intention.addGoalListener(goalListener);
            }
        }
        this.fireGoalEvent(new GoalEvent(goal));
        this.restart();
        return intention;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addSoftgoal(Softgoal softgoal) {
        Set<Softgoal> set = this.softgoals;
        synchronized (set) {
            this.softgoals.add(softgoal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canHandle(ACLMessage msg) {
        Set<Capability> set = this.aggregatedCapabilities;
        synchronized (set) {
            Capability capability;
            Iterator<Capability> iterator = this.aggregatedCapabilities.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(capability = iterator.next()).canHandle(msg));
            return true;
        }
    }

    private final void computeGoalOwnersMap() {
        this.restrictedAccessOwnersMap = new HashMap<Class<? extends Capability>, Set<Capability>>();
        for (Capability capability : this.aggregatedCapabilities) {
            ReflectionUtils.addGoalOwner(this.restrictedAccessOwnersMap, capability);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dropGoal(Goal goal) {
        Map<Goal, Intention> map = this.allIntentions;
        synchronized (map) {
            Intention intention = this.allIntentions.get(goal);
            if (intention != null) {
                intention.noLongerDesire();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dropSoftoal(Softgoal softgoal) {
        Set<Softgoal> set = this.softgoals;
        synchronized (set) {
            this.softgoals.remove(softgoal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fireGoalEvent(GoalEvent goalEvent) {
        List<GoalListener> list = this.goalListeners;
        synchronized (list) {
            for (GoalListener goalListener : this.goalListeners) {
                goalListener.goalPerformed(goalEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fireGoalEvent(Intention intention) {
        Goal goal = intention.getGoal();
        GoalStatus status = intention.getStatus();
        log.debug((Object)("Goal: " + goal.getClass().getSimpleName() + " (" + (Object)((Object)status) + ") - " + goal));
        GoalEvent goalEvent = new GoalEvent(goal, status);
        List<GoalListener> list = this.goalListeners;
        synchronized (list) {
            for (GoalListener goalListener : this.goalListeners) {
                goalListener.goalPerformed(goalEvent);
            }
            for (GoalListener goalListener : intention.getGoalListeners()) {
                goalListener.goalPerformed(goalEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<Capability> getAllCapabilities() {
        Set<Capability> set = this.aggregatedCapabilities;
        synchronized (set) {
            return this.capabilities;
        }
    }

    @Override
    public final AgentBeliefRevisionStrategy getBeliefRevisionStrategy() {
        return this.beliefRevisionStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<Belief<?, ?>> getBeliefs() {
        Set<Capability> set = this.aggregatedCapabilities;
        synchronized (set) {
            LinkedList beliefs = new LinkedList();
            for (Capability capability : this.capabilities) {
                beliefs.addAll(capability.getBeliefBase().getBeliefs());
            }
            return beliefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<Capability> getCapabilities() {
        Set<Capability> set = this.aggregatedCapabilities;
        synchronized (set) {
            return this.aggregatedCapabilities;
        }
    }

    @Override
    public final AgentDeliberationFunction getDeliberationFunction() {
        return this.deliberationFunction;
    }

    @Override
    public final List<GoalListener> getGoalListeners() {
        return this.goalListeners;
    }

    protected final Set<Capability> getGoalOwner(Class<? extends Capability> owner, boolean internal) {
        if (internal) {
            return new HashSet<Capability>();
        }
        HashSet restrictedAccessOwners = this.restrictedAccessOwnersMap.get(owner);
        return restrictedAccessOwners == null ? new HashSet() : restrictedAccessOwners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<Goal> getGoals() {
        Map<Goal, Intention> map = this.allIntentions;
        synchronized (map) {
            return this.allIntentions.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<Intention> getIntentions() {
        Map<Goal, Intention> map = this.allIntentions;
        synchronized (map) {
            HashSet<Intention> activeIntentions = new HashSet<Intention>();
            for (Intention intention : activeIntentions) {
                if (GoalStatus.WAITING.equals((Object)intention.getStatus())) continue;
                activeIntentions.add(intention);
            }
            return activeIntentions;
        }
    }

    @Override
    public final AgentOptionGenerationFunction getOptionGenerationFunction() {
        return this.optionGenerationFunction;
    }

    @Override
    public final AgentPlanSelectionStrategy getPlanSelectionStrategy() {
        return this.planSelectionStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<Softgoal> getSoftgoals() {
        Set<Softgoal> set = this.softgoals;
        synchronized (set) {
            return this.softgoals;
        }
    }

    @Override
    public boolean hasGoal(Goal goal) {
        return this.allIntentions.get(goal) != null;
    }

    protected void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeCapability(Capability capability) {
        Set<Capability> set = this.aggregatedCapabilities;
        synchronized (set) {
            boolean removed = this.aggregatedCapabilities.remove(capability);
            if (removed) {
                this.resetAllCapabilities();
                this.computeGoalOwnersMap();
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeGoalListener(GoalListener goalListener) {
        List<GoalListener> list = this.goalListeners;
        synchronized (list) {
            this.goalListeners.remove(goalListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resetAllCapabilities() {
        Set<Capability> set = this.aggregatedCapabilities;
        synchronized (set) {
            Set<Capability> oldCapabilities = this.capabilities;
            HashSet<Capability> allCapabilities = new HashSet<Capability>();
            for (Capability capability : this.aggregatedCapabilities) {
                allCapabilities.add(capability);
                capability.addRelatedCapabilities(allCapabilities);
            }
            this.capabilities = allCapabilities;
            log.debug((Object)("Capabilities: " + this.capabilities));
            HashSet<Capability> removedCapabilities = new HashSet<Capability>(oldCapabilities);
            removedCapabilities.removeAll(allCapabilities);
            for (Capability capability : removedCapabilities) {
                capability.setMyAgent(null);
            }
            HashSet<Capability> addedCapabilities = new HashSet<Capability>(allCapabilities);
            addedCapabilities.removeAll(oldCapabilities);
            for (Capability capability : addedCapabilities) {
                if (capability.getMyAgent() != null) {
                    throw new IllegalArgumentException("Capability already binded to another agent: " + capability.getFullId());
                }
                capability.setMyAgent(this);
            }
        }
    }

    @Override
    public final void restart() {
        this.bdiInterpreter.restart();
    }

    public final void setBeliefRevisionStrategy(AgentBeliefRevisionStrategy beliefRevisionStrategy) {
        if (beliefRevisionStrategy == null) {
            this.beliefRevisionStrategy = new DefaultAgentBeliefRevisionStrategy();
        } else {
            this.beliefRevisionStrategy.setAgent(null);
            this.beliefRevisionStrategy = beliefRevisionStrategy;
        }
        this.beliefRevisionStrategy.setAgent(this);
    }

    public final void setDeliberationFunction(AgentDeliberationFunction deliberationFunction) {
        if (deliberationFunction == null) {
            this.deliberationFunction = new DefaultAgentDeliberationFunction();
        } else {
            this.deliberationFunction.setAgent(null);
            this.deliberationFunction = deliberationFunction;
        }
        this.deliberationFunction.setAgent(this);
    }

    public final void setOptionGenerationFunction(AgentOptionGenerationFunction optionGenerationFunction) {
        if (optionGenerationFunction == null) {
            this.optionGenerationFunction = new DefaultAgentOptionGenerationFunction();
        } else {
            this.optionGenerationFunction.setAgent(null);
            this.optionGenerationFunction = optionGenerationFunction;
        }
        this.optionGenerationFunction.setAgent(this);
    }

    public final void setPlanSelectionStrategy(AgentPlanSelectionStrategy planSelectionStrategy) {
        if (planSelectionStrategy == null) {
            this.planSelectionStrategy = new DefaultAgentPlanSelectionStrategy();
        } else {
            this.planSelectionStrategy.setAgent(null);
            this.planSelectionStrategy = planSelectionStrategy;
        }
        this.planSelectionStrategy.setAgent(this);
    }

    protected final void setup() {
        this.addBehaviour((Behaviour)new BDIAgentMsgReceiver(this));
        this.addBehaviour((Behaviour)this.bdiInterpreter);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void takeDown() {
        Set<Capability> set = this.aggregatedCapabilities;
        synchronized (set) {
            Iterator<Capability> iterator = this.aggregatedCapabilities.iterator();
            while (iterator.hasNext()) {
                this.removeCapability(iterator.next());
            }
        }
    }

    class BDIInterpreter
    extends CyclicBehaviour {
        private static final long serialVersionUID = -6991759791322598475L;

        private BDIInterpreter(BDIAgent bdiAgent) {
            super((Agent)bdiAgent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void action() {
            log.trace((Object)"Beginning BDI-interpreter cycle.");
            log.trace((Object)"Reviewing beliefs.");
            AbstractBDIAgent.this.beliefRevisionStrategy.reviewBeliefs();
            Map map = AbstractBDIAgent.this.allIntentions;
            synchronized (map) {
                GoalUpdateSet agentGoalUpdateSet = this.processIntentions(AbstractBDIAgent.this.agentIntentions);
                HashMap<Capability, GoalUpdateSet> capabilityGoalUpdateSets = new HashMap<Capability, GoalUpdateSet>();
                for (Capability capability : AbstractBDIAgent.this.capabilities) {
                    GoalUpdateSet goalUpdateSet = this.processIntentions(capability.getIntentions());
                    capabilityGoalUpdateSets.put(capability, goalUpdateSet);
                }
                AbstractBDIAgent.this.optionGenerationFunction.generateGoals(agentGoalUpdateSet, capabilityGoalUpdateSets);
                for (GoalUpdateSet.GoalDescription goal : agentGoalUpdateSet.getGeneratedGoals()) {
                    try {
                        Intention intention = AbstractBDIAgent.this.addIntention(goal.getDispatcher(), goal.getGoal(), goal.getListener());
                        if (intention == null) continue;
                        agentGoalUpdateSet.addIntention(intention);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        log.error((Object)illegalAccessException);
                    }
                }
                for (GoalUpdateSet goalUpdateSet : capabilityGoalUpdateSets.values()) {
                    for (GoalUpdateSet.GoalDescription goalDescription : goalUpdateSet.getGeneratedGoals()) {
                        try {
                            Intention intention = AbstractBDIAgent.this.addIntention(goalDescription.getDispatcher(), goalDescription.getGoal(), goalDescription.getListener());
                            if (intention == null) continue;
                            goalUpdateSet.addIntention(intention);
                        }
                        catch (IllegalAccessException exc) {
                            log.error((Object)exc);
                        }
                    }
                }
                for (GoalUpdateSet.GoalDescription goal : agentGoalUpdateSet.getDroppedGoals()) {
                    goal.getIntention().noLongerDesire();
                    AbstractBDIAgent.this.fireGoalEvent(goal.getIntention());
                    AbstractBDIAgent.this.agentIntentions.remove(goal.getIntention());
                    AbstractBDIAgent.this.allIntentions.remove(goal.getGoal());
                    agentGoalUpdateSet.removeIntention(goal);
                }
                for (GoalUpdateSet goalUpdateSet : capabilityGoalUpdateSets.values()) {
                    for (GoalUpdateSet.GoalDescription goalDescription : goalUpdateSet.getDroppedGoals()) {
                        goalDescription.getIntention().noLongerDesire();
                        AbstractBDIAgent.this.fireGoalEvent(goalDescription.getIntention());
                        goalDescription.getDispatcher().removeIntention(goalDescription.getIntention());
                        AbstractBDIAgent.this.allIntentions.remove(goalDescription.getGoal());
                        goalUpdateSet.removeIntention(goalDescription);
                    }
                }
                HashMap<Capability, Set<GoalUpdateSet.GoalDescription>> capabilityGoals = new HashMap<Capability, Set<GoalUpdateSet.GoalDescription>>();
                for (Capability capability : capabilityGoalUpdateSets.keySet()) {
                    capabilityGoals.put(capability, ((GoalUpdateSet)capabilityGoalUpdateSets.get(capability)).getCurrentGoals());
                }
                Set<Goal> selectedGoals = AbstractBDIAgent.this.deliberationFunction.filter(agentGoalUpdateSet.getCurrentGoals(), capabilityGoals);
                log.trace((Object)("Selected goals to be intentions: " + selectedGoals.size()));
                for (Intention intention : AbstractBDIAgent.this.allIntentions.values()) {
                    if (selectedGoals.contains(intention.getGoal())) {
                        intention.tryToAchive();
                        continue;
                    }
                    intention.doWait();
                }
                if (AbstractBDIAgent.this.allIntentions.isEmpty()) {
                    log.trace((Object)"No goals or intentions: blocking cycle.");
                    this.block();
                }
            }
            log.trace((Object)"BDI-interpreter cycle finished.");
        }

        private GoalUpdateSet processIntentions(Collection<Intention> intentions) {
            GoalUpdateSet goalUpdateSet = new GoalUpdateSet();
            ArrayList<Intention> intentionsList = new ArrayList<Intention>(intentions);
            for (Intention intention : intentionsList) {
                GoalStatus status = intention.getStatus();
                if (status.isFinished()) {
                    AbstractBDIAgent.this.fireGoalEvent(intention);
                    intentions.remove(intention);
                    AbstractBDIAgent.this.allIntentions.remove(intention.getGoal());
                    continue;
                }
                if (GoalStatus.PLAN_FAILED.equals((Object)status)) {
                    AbstractBDIAgent.this.fireGoalEvent(intention);
                }
                goalUpdateSet.addIntention(intention);
            }
            return goalUpdateSet;
        }
    }
}

